/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.EMouseAction;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.sliders.DoubleLabeledSlider;
import com.google.security.zynamics.zylib.gui.zygraph.MouseWheelAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ControlsPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 4;
    private final JComboBox<String> showScrollbars = new JComboBox();
    private final JComboBox<String> mouseWheelBehavior = new JComboBox();
    private final DoubleLabeledSlider zoomSensitivity = new DoubleLabeledSlider("  Low  ", "  High  ", 1, 10, false, new LineBorder(Color.GRAY));
    private final DoubleLabeledSlider scrollSensitivity = new DoubleLabeledSlider("  Low  ", "  High  ", 1, 10, false, new LineBorder(Color.GRAY));
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public ControlsPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public ControlsPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.zoomSensitivity.setInverted(true);
        this.scrollSensitivity.setInverted(true);
        this.init(string);
    }

    private EMouseAction getMouseWheelBehaviour(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getMouseWheelAction();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getMouseWheelAction();
            }
        }
        return this.settings.getMouseSettings().getMouseWheelAction() == MouseWheelAction.ZOOM ? EMouseAction.ZOOM : EMouseAction.SCROLL;
    }

    private int getScrollSensitivity(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getScrollSensitivity();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getScrollSensitivity();
            }
        }
        return this.settings.getMouseSettings().getScrollSensitivity();
    }

    private boolean getShowScrollbars(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getShowScrollbars();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getShowScrollbars();
            }
        }
        return this.settings.getShowScrollbars();
    }

    private int getZoomSensitivity(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getZoomSensitivity();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getZoomSensitivity();
            }
        }
        return this.settings.getMouseSettings().getZoomSensitivity();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.showScrollbars.addItem("Always");
        this.showScrollbars.addItem("Never");
        this.mouseWheelBehavior.addItem("Zoom");
        this.mouseWheelBehavior.addItem("Scroll");
        this.setCurrentValues();
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Show scrollbars", 275, this.showScrollbars, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Mousewheel action", 275, this.mouseWheelBehavior, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Zoom sensitivity", 275, this.zoomSensitivity, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Scroll sensitivity", 275, this.scrollSensitivity, 25));
        this.add((Component)jPanel, "North");
    }

    public EMouseAction getMouseWheelBehavior() {
        return this.mouseWheelBehavior.getSelectedIndex() == 0 ? EMouseAction.ZOOM : EMouseAction.SCROLL;
    }

    public int getScrollSensitivity() {
        return this.scrollSensitivity.getValue();
    }

    public boolean getShowScrollbars() {
        return this.showScrollbars.getSelectedIndex() == 0;
    }

    public int getZoomSensitivity() {
        return this.zoomSensitivity.getValue();
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.showScrollbars.setSelectedIndex(this.getShowScrollbars(binDiffConfig) ? 0 : 1);
        this.mouseWheelBehavior.setSelectedIndex(this.getMouseWheelBehaviour(binDiffConfig) == EMouseAction.ZOOM ? 0 : 1);
        this.zoomSensitivity.setValue(this.getZoomSensitivity(binDiffConfig));
        this.scrollSensitivity.setValue(this.getScrollSensitivity(binDiffConfig));
    }
}

