/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.ECircularLayoutStyle;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;

public class CircularLayoutPanel
extends JPanel {
    private static final int LABEL_WIDTH = 275;
    private static final int ROW_HEIGHT = 25;
    private static final int NUMBER_OF_ROWS = 2;
    private final JComboBox<String> layoutStyle = new JComboBox();
    private final JFormattedTextField minimumNodeDistance = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(new CDecFormatter(3))));
    private final ESettingsDialogType dialogType;
    private final GraphSettings settings;

    public CircularLayoutPanel(String string, ESettingsDialogType eSettingsDialogType) {
        this(string, eSettingsDialogType, null);
    }

    public CircularLayoutPanel(String string, ESettingsDialogType eSettingsDialogType, GraphSettings graphSettings) {
        super(new BorderLayout());
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(graphSettings == null ^ eSettingsDialogType == ESettingsDialogType.GRAPH_VIEW_SETTINGS);
        this.dialogType = eSettingsDialogType;
        this.settings = graphSettings;
        this.init(string);
    }

    private ECircularLayoutStyle getCircularLayoutStyle(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getCircularLayoutStyle();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getCircularLayoutStyle();
            }
        }
        return this.settings.getLayoutSettings().getCircularLayoutStyle();
    }

    private int getMinimumNodeDistance(BinDiffConfig binDiffConfig) {
        switch (this.dialogType) {
            case INITIAL_CALL_GRAPH_SETTING: {
                return binDiffConfig.getInitialCallGraphSettings().getCircularMinimumNodeDistance();
            }
            case INITIAL_FLOW_GRAPH_SETTINGS: {
                return binDiffConfig.getInitialFlowGraphSettings().getCircularMinimumNodeDistance();
            }
        }
        return (int)this.settings.getLayoutSettings().getMinimumCircularNodeDistance();
    }

    private void init(String string) {
        this.setBorder(new LineBorder(Color.GRAY));
        this.layoutStyle.addItem("Compact");
        this.layoutStyle.addItem("Isolated");
        this.layoutStyle.addItem("Single Cycle");
        this.setCurrentValues();
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel.setBorder(new TitledBorder(string));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Layout style", 275, this.layoutStyle, 25));
        jPanel.add(GuiUtils.createHorizontalNamedComponentPanel("Preferred node distance", 275, this.minimumNodeDistance, 25));
        this.add((Component)jPanel, "North");
    }

    public ECircularLayoutStyle getCircularLayoutStyle() {
        return ECircularLayoutStyle.getEnum(this.layoutStyle.getSelectedIndex());
    }

    public int getMinimumNodeDistance() {
        return Integer.parseInt(this.minimumNodeDistance.getText());
    }

    public void setCurrentValues() {
        BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
        this.layoutStyle.setSelectedIndex(ECircularLayoutStyle.getOrdinal(this.getCircularLayoutStyle(binDiffConfig)));
        this.minimumNodeDistance.setText(Integer.toString(this.getMinimumNodeDistance(binDiffConfig)));
    }
}

