/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphsettings;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.settings.GraphLayoutSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphMouseSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphSettings;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.ESettingsDialogType;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.CircularLayoutPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.ControlsPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.EdgesPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.HierarchicalLayoutPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.MiscPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.OrthogonalLayoutPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphsettings.panels.ProximityBrowsingPanel;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class GraphSettingsDialog
extends BaseDialog
implements ActionListener {
    private static final int DIALOG_WIDTH = 630;
    private static final int DIALOG_HEIGHT = 282;
    private final ProximityBrowsingPanel proximityBrowsingPanel;
    private final EdgesPanel edgesPanel;
    private final HierarchicalLayoutPanel hierarchicalLayoutPanel;
    private final OrthogonalLayoutPanel orthogonalLayoutPanel;
    private final CircularLayoutPanel circularLayoutPanel;
    private final ControlsPanel controlsPanel;
    private final MiscPanel miscPanel;
    private final CPanelTwoButtons buttons = new CPanelTwoButtons(this, "Ok", "Cancel");
    private final GraphSettings settings;

    public GraphSettingsDialog(Window window, GraphSettings graphSettings) {
        super(window, "Graph View Settings");
        this.settings = Preconditions.checkNotNull(graphSettings);
        this.proximityBrowsingPanel = new ProximityBrowsingPanel("Proximity Browsing", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.edgesPanel = new EdgesPanel("Edges", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.hierarchicalLayoutPanel = new HierarchicalLayoutPanel("Hierarchical Layout", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.orthogonalLayoutPanel = new OrthogonalLayoutPanel("Orthogonal Layout", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.circularLayoutPanel = new CircularLayoutPanel("Circular Layout", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.controlsPanel = new ControlsPanel("Controls", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.miscPanel = new MiscPanel("Miscellaneous", ESettingsDialogType.GRAPH_VIEW_SETTINGS, graphSettings);
        this.init();
        this.pack();
        this.setSize(630, 282);
        this.setMinimumSize(new Dimension(630, 282));
        GuiHelper.centerChildToParent(window, this, true);
    }

    private void applySettings() {
        GraphLayoutSettings graphLayoutSettings = this.settings.getLayoutSettings();
        graphLayoutSettings.setVisibilityWarningThreshold(this.proximityBrowsingPanel.getVisibilityWarningThreshold());
        GraphProximityBrowsingSettings graphProximityBrowsingSettings = this.settings.getProximitySettings();
        graphProximityBrowsingSettings.setAutoProximityBrowsingActivationThreshold(this.proximityBrowsingPanel.getAutoProximityBrowsingActivationThreshold());
        graphProximityBrowsingSettings.setProximityBrowsingChildren(this.proximityBrowsingPanel.getProximityBrowsingChildDepth());
        graphProximityBrowsingSettings.setProximityBrowsingParents(this.proximityBrowsingPanel.getProximityBrowsingParentDepth());
        this.settings.setDrawBends(this.edgesPanel.getDrawBends());
        graphLayoutSettings.setHierarchicOrthogonalEdgeRouting(this.hierarchicalLayoutPanel.getOrthogonalEdgeRouting());
        graphLayoutSettings.setHierarchicOrientation(this.hierarchicalLayoutPanel.getLayoutOrientation());
        graphLayoutSettings.setMinimumHierarchicLayerDistance(this.hierarchicalLayoutPanel.getMinimumLayerDistance());
        graphLayoutSettings.setMinimumHierarchicNodeDistance(this.hierarchicalLayoutPanel.getMinimumNodeDistance());
        graphLayoutSettings.setOrthogonalLayoutStyle(this.orthogonalLayoutPanel.getOrthogonalLayoutStyle());
        graphLayoutSettings.setOrthogonalLayoutOrientation(this.orthogonalLayoutPanel.getOrthogonalOrientation());
        graphLayoutSettings.setMinimumOrthogonalNodeDistance(this.orthogonalLayoutPanel.getMinimumNodeDistance());
        graphLayoutSettings.setCircularLayoutStyle(this.circularLayoutPanel.getCircularLayoutStyle());
        graphLayoutSettings.setMinimumCircularNodeDistance(this.circularLayoutPanel.getMinimumNodeDistance());
        this.settings.setShowScrollbars(this.controlsPanel.getShowScrollbars());
        GraphMouseSettings graphMouseSettings = this.settings.getMouseSettings();
        graphMouseSettings.setMousewheelAction(this.controlsPanel.getMouseWheelBehavior());
        graphMouseSettings.setZoomSensitivity(this.controlsPanel.getZoomSensitivity());
        graphMouseSettings.setScrollSensitivity(this.controlsPanel.getScrollSensitivity());
        this.settings.getDisplaySettings().setAnimationSpeed(this.miscPanel.getAnimationSpeed());
        this.settings.getLayoutSettings().updateLayouter();
    }

    private void init() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Browsing", this.proximityBrowsingPanel);
        jTabbedPane.addTab("Edges", this.edgesPanel);
        jTabbedPane.addTab("Hierarchical", this.hierarchicalLayoutPanel);
        jTabbedPane.addTab("Orthogonal", this.orthogonalLayoutPanel);
        jTabbedPane.addTab("Circular", this.circularLayoutPanel);
        jTabbedPane.addTab("Controls", this.controlsPanel);
        jTabbedPane.addTab("Misc", this.miscPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        jPanel.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)this.buttons, "South");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setVisible(boolean bl2) {
        this.proximityBrowsingPanel.setCurrentValues();
        this.edgesPanel.setCurrentValues();
        this.hierarchicalLayoutPanel.setCurrentValues();
        this.orthogonalLayoutPanel.setCurrentValues();
        this.circularLayoutPanel.setCurrentValues();
        this.controlsPanel.setCurrentValues();
        this.miscPanel.setCurrentValues();
        super.setVisible(bl2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Ok")) {
            this.applySettings();
        }
        this.dispose();
    }
}

