/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphnodetreeoptionsdialog.tabpanels;

import com.google.common.collect.Lists;
import com.google.security.zynamics.bindiff.enums.ESortByCriterion;
import com.google.security.zynamics.bindiff.enums.ESortOrder;
import com.google.security.zynamics.bindiff.gui.dialogs.graphnodetreeoptionsdialog.tabcomponents.SortingComboboxPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class SortingTabPanel
extends JPanel {
    private static final int SORTING_LABEL_WIDTH = 100;
    private static final int SORTING_COMBOBOX_WIDTH = 150;
    private static final int ROW_HEIGHT = 25;
    private SortingComboboxPanel firstSortCombo;
    private SortingComboboxPanel secondSortCombo;
    private SortingComboboxPanel thirdSortCombo;
    private SortingComboboxPanel fourthSortCombo;
    private SortingComboboxPanel fifthSortCombo;
    private final boolean isCallGraphView;
    private final boolean isCombinedView;
    private ESortOrder initialFirstOrder;
    private ESortOrder initialSecondOrder;
    private ESortOrder initialThirdOrder;
    private ESortOrder initialFourthOrder;
    private ESortOrder initialFifthOrder;
    private ESortByCriterion initialFirstCriterion;
    private ESortByCriterion initialSecondCriterion;
    private ESortByCriterion initialThirdCriterion;
    private ESortByCriterion initialFourthCriterion;
    private ESortByCriterion initialFifthCriterion;

    public SortingTabPanel(boolean bl2, boolean bl3) {
        super(new BorderLayout());
        this.add((Component)this.createPanel(bl2, bl3), "Center");
        this.isCallGraphView = bl3;
        this.isCombinedView = bl2;
        this.setDefaults();
    }

    private JPanel createPanel(boolean bl2, boolean bl3) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new LineBorder(Color.GRAY));
        JPanel jPanel2 = new JPanel(new GridLayout(bl2 ? 6 : 5, 1, 2, 2));
        jPanel2.setBorder(new TitledBorder("Sort Options"));
        ArrayList<String> arrayList = Lists.newArrayList(ESortByCriterion.NONE.toString(), ESortByCriterion.ADDRESS.toString(), ESortByCriterion.MATCH_STATE.toString(), ESortByCriterion.SELECTION.toString(), ESortByCriterion.VISIBILITY.toString());
        if (bl2) {
            arrayList.add(ESortByCriterion.SIDE.toString());
        }
        if (bl3) {
            arrayList.add(2, ESortByCriterion.FUNCTION_TYPE.toString());
            if (!bl2) {
                arrayList.add(3, ESortByCriterion.FUNCTION_NAME.toString());
            }
        }
        this.firstSortCombo = new SortingComboboxPanel("First", arrayList, 100, 150, 25);
        this.secondSortCombo = new SortingComboboxPanel("Second", arrayList, 100, 150, 25);
        this.thirdSortCombo = new SortingComboboxPanel("Third", arrayList, 100, 150, 25);
        this.fourthSortCombo = new SortingComboboxPanel("Fourth", arrayList, 100, 150, 25);
        this.fifthSortCombo = new SortingComboboxPanel("Fifth", arrayList, 100, 150, 25);
        jPanel2.add(this.firstSortCombo);
        jPanel2.add(this.secondSortCombo);
        jPanel2.add(this.thirdSortCombo);
        jPanel2.add(this.fourthSortCombo);
        jPanel2.add(this.fifthSortCombo);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    public ESortByCriterion getSortByCriterion(int n2) {
        switch (n2) {
            case 0: {
                return ESortByCriterion.toSortCriterion(this.firstSortCombo.getValue());
            }
            case 1: {
                return ESortByCriterion.toSortCriterion(this.secondSortCombo.getValue());
            }
            case 2: {
                return ESortByCriterion.toSortCriterion(this.thirdSortCombo.getValue());
            }
            case 3: {
                return ESortByCriterion.toSortCriterion(this.fourthSortCombo.getValue());
            }
            case 4: {
                return ESortByCriterion.toSortCriterion(this.fifthSortCombo.getValue());
            }
        }
        return ESortByCriterion.NONE;
    }

    public ESortOrder getSortOrder(int n2) {
        switch (n2) {
            case 0: {
                return this.firstSortCombo.getSortOrder();
            }
            case 1: {
                return this.secondSortCombo.getSortOrder();
            }
            case 2: {
                return this.thirdSortCombo.getSortOrder();
            }
            case 3: {
                return this.fourthSortCombo.getSortOrder();
            }
            case 4: {
                return this.fifthSortCombo.getSortOrder();
            }
        }
        return ESortOrder.ASCENDING;
    }

    public void restoreInitialSettings() {
        this.firstSortCombo.setSelectItem(this.initialFirstCriterion.toString(), this.initialFirstOrder);
        this.secondSortCombo.setSelectItem(this.initialSecondCriterion.toString(), this.initialSecondOrder);
        this.thirdSortCombo.setSelectItem(this.initialThirdCriterion.toString(), this.initialThirdOrder);
        this.fourthSortCombo.setSelectItem(this.initialFourthCriterion.toString(), this.initialFourthOrder);
        this.fifthSortCombo.setSelectItem(this.initialFifthCriterion.toString(), this.initialFifthOrder);
    }

    public void setDefaults() {
        if (!this.isCallGraphView) {
            this.secondSortCombo.setSelectItem(ESortByCriterion.MATCH_STATE.toString(), ESortOrder.ASCENDING);
            if (!this.isCombinedView) {
                this.fourthSortCombo.setSelectItem(ESortByCriterion.ADDRESS.toString(), ESortOrder.ASCENDING);
                this.fifthSortCombo.setSelectItem(ESortByCriterion.NONE.toString(), ESortOrder.ASCENDING);
            } else {
                this.fourthSortCombo.setSelectItem(ESortByCriterion.SIDE.toString(), ESortOrder.ASCENDING);
                this.fifthSortCombo.setSelectItem(ESortByCriterion.ADDRESS.toString(), ESortOrder.ASCENDING);
            }
        } else {
            this.secondSortCombo.setSelectItem(ESortByCriterion.FUNCTION_TYPE.toString(), ESortOrder.ASCENDING);
            this.thirdSortCombo.setSelectItem(ESortByCriterion.MATCH_STATE.toString(), ESortOrder.ASCENDING);
            this.fifthSortCombo.setSelectItem(ESortByCriterion.ADDRESS.toString(), ESortOrder.ASCENDING);
        }
    }

    public void storeInitialSettings() {
        this.initialFirstOrder = this.firstSortCombo.getSortOrder();
        this.initialSecondOrder = this.secondSortCombo.getSortOrder();
        this.initialThirdOrder = this.thirdSortCombo.getSortOrder();
        this.initialFourthOrder = this.fourthSortCombo.getSortOrder();
        this.initialFifthOrder = this.fifthSortCombo.getSortOrder();
        this.initialFirstCriterion = this.getSortByCriterion(0);
        this.initialSecondCriterion = this.getSortByCriterion(1);
        this.initialThirdCriterion = this.getSortByCriterion(2);
        this.initialFourthCriterion = this.getSortByCriterion(3);
        this.initialFifthCriterion = this.getSortByCriterion(4);
    }
}

