/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.graphnodetreeoptionsdialog.tabpanels;

import com.google.common.collect.Lists;
import com.google.security.zynamics.bindiff.graph.filter.enums.EMatchStateFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.ESelectionFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.ESideFilter;
import com.google.security.zynamics.bindiff.graph.filter.enums.EVisibilityFilter;
import com.google.security.zynamics.bindiff.gui.dialogs.graphnodetreeoptionsdialog.tabcomponents.AddressRangeFieldPanel;
import com.google.security.zynamics.bindiff.gui.dialogs.graphnodetreeoptionsdialog.tabcomponents.FilterComboboxPanel;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class FilteringTabPanel
extends JPanel {
    private static final int FILTER_LABEL_WIDTH = 100;
    private static final int FILTER_COMBOBOX_WIDTH = 150;
    private static final int ROW_HEIGHT = 25;
    private static final String FILTER_ITEM_NONE = "None";
    private static final String FILTER_ITEM_PRIMARY = "Primary";
    private static final String FILTER_ITEM_SECONRARY = "Secondary";
    private static final String FILTER_ITEM_SELECTED = "Selected";
    private static final String FILTER_ITEM_UNSELECTED = "Unselected";
    private static final String FILTER_ITEM_VISIBLE = "Visible";
    private static final String FILTER_ITEM_INVISIBLE = "Invisible";
    private static final String FILTER_ITEM_MATCHED = "Matched";
    private static final String FILTER_ITEM_MATCHED_IDENTICAL = "Matched Identical";
    private static final String FILTER_ITEM_MATCHED_INSTRUCTION_CHANGES = "Matched with Changes";
    private static final String FILTER_ITEM_MATCHED_INSTRUCTION_ONLY_CHANGES = "Matched with Instruction Changes Only";
    private static final String FILTER_ITEM_MATCHED_STRUCTURAL_CHANGES = "Matched with structural Changes";
    private static final String FILTER_ITEM_UNMATCHED = "Unmatched";
    private FilterComboboxPanel matchStateCombo;
    private FilterComboboxPanel selectionCombo;
    private FilterComboboxPanel visibilityCombo;
    private FilterComboboxPanel sideCombo;
    private AddressRangeFieldPanel startRangeField;
    private AddressRangeFieldPanel endRangeField;
    private String initialSelection;
    private String initialVisibility;
    private String initialMatchState;
    private String initialSide;
    private IAddress initialStartRange;
    private IAddress initialEndRange;

    public FilteringTabPanel(boolean bl2, boolean bl3) {
        super(new BorderLayout());
        this.add((Component)this.createPanel(bl2, bl3), "Center");
        this.setDefaults();
    }

    private JPanel createPanel(boolean bl2, boolean bl3) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new LineBorder(Color.GRAY));
        JPanel jPanel2 = new JPanel(new GridLayout(bl2 ? 6 : 5, 1, 2, 2));
        jPanel2.setBorder(new TitledBorder("Filter Options"));
        ArrayList<String> arrayList = Lists.newArrayList(FILTER_ITEM_NONE, FILTER_ITEM_MATCHED, FILTER_ITEM_UNMATCHED);
        ArrayList<String> arrayList2 = Lists.newArrayList(FILTER_ITEM_NONE, FILTER_ITEM_SELECTED, FILTER_ITEM_UNSELECTED);
        ArrayList<String> arrayList3 = Lists.newArrayList(FILTER_ITEM_NONE, FILTER_ITEM_VISIBLE, FILTER_ITEM_INVISIBLE);
        ArrayList<String> arrayList4 = Lists.newArrayList(FILTER_ITEM_NONE, FILTER_ITEM_PRIMARY, FILTER_ITEM_SECONRARY);
        if (bl3) {
            arrayList.add(2, FILTER_ITEM_MATCHED_IDENTICAL);
            arrayList.add(3, FILTER_ITEM_MATCHED_INSTRUCTION_ONLY_CHANGES);
            arrayList.add(4, FILTER_ITEM_MATCHED_STRUCTURAL_CHANGES);
        } else {
            arrayList.add(2, FILTER_ITEM_MATCHED_IDENTICAL);
            arrayList.add(3, FILTER_ITEM_MATCHED_INSTRUCTION_CHANGES);
        }
        this.matchStateCombo = new FilterComboboxPanel("Match State", arrayList, 100, 150, 25);
        this.selectionCombo = new FilterComboboxPanel("Selection", arrayList2, 100, 150, 25);
        this.sideCombo = new FilterComboboxPanel("Side", arrayList4, 100, 150, 25);
        this.visibilityCombo = new FilterComboboxPanel("Visibility", arrayList3, 100, 150, 25);
        this.startRangeField = new AddressRangeFieldPanel("Start Range", new CAddress("0000000000000000", 16), 100, 150, 25);
        this.endRangeField = new AddressRangeFieldPanel("End Range", new CAddress("FFFFFFFFFFFFFFFF", 16), 100, 150, 25);
        jPanel2.add(this.matchStateCombo);
        jPanel2.add(this.selectionCombo);
        jPanel2.add(this.visibilityCombo);
        if (bl2) {
            jPanel2.add(this.sideCombo);
        }
        jPanel2.add(this.startRangeField);
        jPanel2.add(this.endRangeField);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    public IAddress getEndAddress() {
        return this.endRangeField.getValue();
    }

    public EMatchStateFilter getMatchStateFilter() {
        if (this.matchStateCombo.getValue().equals(FILTER_ITEM_MATCHED)) {
            return EMatchStateFilter.MATCHED;
        }
        if (this.matchStateCombo.getValue().equals(FILTER_ITEM_UNMATCHED)) {
            return EMatchStateFilter.UNMATCHED;
        }
        if (this.matchStateCombo.getValue().equals(FILTER_ITEM_MATCHED_IDENTICAL)) {
            return EMatchStateFilter.MATCHED_IDENTICAL;
        }
        if (this.matchStateCombo.getValue().equals(FILTER_ITEM_MATCHED_INSTRUCTION_ONLY_CHANGES)) {
            return EMatchStateFilter.MATCHED_INSTRUCTION_CHANGES;
        }
        if (this.matchStateCombo.getValue().equals(FILTER_ITEM_MATCHED_INSTRUCTION_CHANGES)) {
            return EMatchStateFilter.MATCHED_INSTRUCTION_CHANGES;
        }
        if (this.matchStateCombo.getValue().equals(FILTER_ITEM_MATCHED_STRUCTURAL_CHANGES)) {
            return EMatchStateFilter.MATCHED_STRUTURAL_CHANGES;
        }
        return EMatchStateFilter.NONE;
    }

    public ESelectionFilter getSelectionFilter() {
        if (this.selectionCombo.getValue().equals(FILTER_ITEM_SELECTED)) {
            return ESelectionFilter.SELECTED;
        }
        if (this.selectionCombo.getValue().equals(FILTER_ITEM_UNSELECTED)) {
            return ESelectionFilter.UNSELECTED;
        }
        return ESelectionFilter.NONE;
    }

    public ESideFilter getSideFilter() {
        if (this.sideCombo.getValue().equals(FILTER_ITEM_PRIMARY)) {
            return ESideFilter.PRIMARY;
        }
        if (this.sideCombo.getValue().equals(FILTER_ITEM_SECONRARY)) {
            return ESideFilter.SECONDARY;
        }
        return ESideFilter.NONE;
    }

    public IAddress getStartAddress() {
        return this.startRangeField.getValue();
    }

    public EVisibilityFilter getVisibilityFilter() {
        if (this.visibilityCombo.getValue().equals(FILTER_ITEM_VISIBLE)) {
            return EVisibilityFilter.VISIBLE;
        }
        if (this.visibilityCombo.getValue().equals(FILTER_ITEM_INVISIBLE)) {
            return EVisibilityFilter.INVISIBLE;
        }
        return EVisibilityFilter.NONE;
    }

    public void restoreInitialSettings() {
        this.selectionCombo.setValue(this.initialSelection);
        this.visibilityCombo.setValue(this.initialVisibility);
        this.matchStateCombo.setValue(this.initialMatchState);
        this.sideCombo.setValue(this.initialSide);
        this.startRangeField.setValue(this.initialStartRange);
        this.endRangeField.setValue(this.initialEndRange);
    }

    public void setDefaults() {
        this.selectionCombo.setValue(FILTER_ITEM_NONE);
        this.visibilityCombo.setValue(FILTER_ITEM_NONE);
        this.matchStateCombo.setValue(FILTER_ITEM_NONE);
        this.sideCombo.setValue(FILTER_ITEM_NONE);
        this.startRangeField.setDefault();
        this.endRangeField.setDefault();
    }

    public void storeInitialSettings() {
        this.initialSelection = this.selectionCombo.getValue();
        this.initialVisibility = this.visibilityCombo.getValue();
        this.initialMatchState = this.matchStateCombo.getValue();
        this.initialSide = this.sideCombo.getValue();
        this.initialStartRange = this.startRangeField.getValue();
        this.initialEndRange = this.endRangeField.getValue();
    }
}

