/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.directorydiff;

import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DiffPairTableData;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.JCheckBoxComparator;
import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;

public class IdbPairTableModel
extends AbstractTableModel {
    public static final int SELECTION = 0;
    public static final int IDB_NAME = 1;
    public static final int IDB_LOCATION = 2;
    public static final int DIFF_DESTINATION_DIR = 3;
    private static final String[] COLUMNS = new String[]{"", "IDB Name", "IDB Location", "Diff Destination (Editable)"};
    private final List<Pair<Integer, Comparator<?>>> sorters = new ArrayList();
    private List<DiffPairTableData> tableData = new ArrayList<DiffPairTableData>();

    public IdbPairTableModel() {
        this.initSorters();
    }

    private void initSorters() {
        this.sorters.add(new Pair<Integer, JCheckBoxComparator>(0, new JCheckBoxComparator()));
        this.sorters.add(new Pair<Integer, LexicalComparator>(1, new LexicalComparator()));
        this.sorters.add(new Pair<Integer, LexicalComparator>(2, new LexicalComparator()));
        this.sorters.add(new Pair<Integer, LexicalComparator>(3, new LexicalComparator()));
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int n2) {
        return COLUMNS[n2];
    }

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    public List<Pair<Integer, Comparator<?>>> getSorters() {
        return this.sorters;
    }

    public List<DiffPairTableData> getTableData() {
        return this.tableData;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        DiffPairTableData diffPairTableData = this.tableData.get(n2);
        switch (n3) {
            case 0: {
                return diffPairTableData.getSelectionCheckBox();
            }
            case 1: {
                return diffPairTableData.getIDBName();
            }
            case 2: {
                return "." + diffPairTableData.getIDBLocation();
            }
            case 3: {
                return diffPairTableData.getDestinationDirectory();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return n3 == 0 || n3 == 3;
    }

    public void setTableData(List<DiffPairTableData> list) {
        this.tableData = list;
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        if (n3 == 0) {
            boolean bl2 = ((JCheckBox)object).isSelected();
            this.tableData.get(n2).getSelectionCheckBox().setSelected(bl2);
        } else if (n3 == 3) {
            this.tableData.get(n2).setDestinationDirectory((String)object);
        }
    }
}

