/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.directorydiff;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.CheckboxCellEditor;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.CheckboxCellRenderer;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DefaultCellRenderer;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DestinationCellRenderer;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DiffPairTableData;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.IdbPairTableModel;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.tables.CTableSorter;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class IdbPairTable
extends JTable {
    private final CTableSorter tableSorter;
    private final IdbPairTableModel model;

    public IdbPairTable(File file, IdbPairTableModel idbPairTableModel) {
        Preconditions.checkNotNull(file);
        this.model = Preconditions.checkNotNull(idbPairTableModel);
        this.tableSorter = new CTableSorter(idbPairTableModel);
        this.setModel(this.tableSorter);
        this.tableSorter.setTableHeader(this.getTableHeader());
        for (Pair<Integer, Comparator<?>> object2 : idbPairTableModel.getSorters()) {
            this.tableSorter.setColumnComparator(object2.first(), object2.second());
        }
        this.getModel().getTableHeader().setToolTipText("Press CTRL to add secondary sort.");
        this.tableSorter.setTableHeader(this.getTableHeader());
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(2);
        TableColumn tableColumn4 = this.getColumnModel().getColumn(3);
        tableColumn.setMaxWidth(30);
        tableColumn.setWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn2.setMinWidth(150);
        tableColumn2.setWidth(150);
        tableColumn4.setMinWidth(375);
        tableColumn4.setWidth(375);
        CheckboxCellRenderer checkboxCellRenderer = new CheckboxCellRenderer();
        tableColumn.setCellRenderer(checkboxCellRenderer);
        tableColumn.setCellEditor(new CheckboxCellEditor());
        DefaultCellRenderer defaultCellRenderer = new DefaultCellRenderer();
        tableColumn2.setCellRenderer(defaultCellRenderer);
        tableColumn3.setCellRenderer(defaultCellRenderer);
        DestinationCellRenderer destinationCellRenderer = new DestinationCellRenderer(file.getPath());
        tableColumn4.setCellRenderer(destinationCellRenderer);
    }

    @Override
    public CTableSorter getModel() {
        return this.tableSorter;
    }

    public IdbPairTableModel getTableModel() {
        return this.model;
    }

    public void setTableData(List<DiffPairTableData> list) {
        this.model.setTableData(list);
    }
}

