/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.directorydiff;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.DiffPairTableData;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.IdbPairTable;
import com.google.security.zynamics.bindiff.gui.dialogs.directorydiff.IdbPairTableModel;
import com.google.security.zynamics.bindiff.project.diff.DiffDirectories;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.gui.CFileChooser;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class DirectoryDiffDialog
extends BaseDialog {
    private static final int DLG_WIDTH = 800;
    private static final int DLG_HEIGHT = 400;
    private static final int MAX_LISTED_FILES = 16;
    private final InternalDirectoryChooserListener dirChooserListener = new InternalDirectoryChooserListener();
    private final InternalButtonListener buttonListener = new InternalButtonListener();
    private final FileChooserPanel primaryDirChooser = new FileChooserPanel("", this.dirChooserListener);
    private final FileChooserPanel secondaryDirChooser = new FileChooserPanel("", this.dirChooserListener);
    private final JButton selectAllButton = new JButton(this.buttonListener);
    private final JButton deselectAllButton = new JButton(this.buttonListener);
    private final JButton diffButton = new JButton(this.buttonListener);
    private final JButton cancelButton = new JButton(this.buttonListener);
    private final IdbPairTable diffsTable;
    private final String workspacePath;
    private boolean diffButtonPressed = true;

    public DirectoryDiffDialog(Window window, File file) {
        super(window, "Directory Diff");
        Preconditions.checkNotNull(file);
        Preconditions.checkArgument(file.exists(), "Workspace directory doesn't exist");
        this.workspacePath = file.getPath();
        this.diffsTable = new IdbPairTable(file, new IdbPairTableModel());
        this.init();
        this.pack();
        this.setPreferredSize(new Dimension(800, 400));
        this.setSize(new Dimension(800, 400));
        GuiHelper.centerChildToParent(window, this, true);
        this.setVisible(true);
    }

    private File chooseFile(Component component, ESide eSide) {
        File file;
        String string;
        CFileChooser cFileChooser = new CFileChooser();
        if (eSide == ESide.PRIMARY) {
            string = "Choose Primary Directory";
            file = new File(this.secondaryDirChooser.getText()).getParentFile();
            if (file != null) {
                BinDiffConfig.getInstance().getMainSettings().setDirectoryDiffLastPrimaryDir(file.getPath());
            }
        } else if (eSide == ESide.SECONDARY) {
            string = "Choose Secondary Directory";
            file = new File(this.primaryDirChooser.getText()).getParentFile();
            if (file != null) {
                BinDiffConfig.getInstance().getMainSettings().setDirectoryDiffLastSecondaryDir(file.getPath());
            }
        } else {
            assert (false);
            throw new RuntimeException();
        }
        cFileChooser.setCurrentDirectory(file);
        cFileChooser.setFileSelectionMode(1);
        cFileChooser.setApproveButtonText("Ok");
        cFileChooser.setDialogTitle(string);
        boolean bl2 = false;
        while (!bl2) {
            if (0 == cFileChooser.showOpenDialog(component)) {
                File file2 = cFileChooser.getSelectedFile();
                if (!file2.exists()) {
                    CMessageBox.showInformation(component, "The selected file does not exist.");
                    continue;
                }
                if (!file2.isDirectory()) {
                    CMessageBox.showInformation(component, "The selected file must be a directory.");
                    continue;
                }
                if (file2.getPath().equals(ESide.PRIMARY == eSide ? this.secondaryDirChooser.getText() : this.primaryDirChooser.getText())) {
                    CMessageBox.showInformation(component, "Primary and secondary directory cannot be identical.");
                    continue;
                }
                return file2;
            }
            bl2 = true;
        }
        return null;
    }

    private Component createButtonsPanel() {
        this.selectAllButton.setText("Select All");
        this.deselectAllButton.setText("Deselect All");
        this.diffButton.setText("Diff");
        this.cancelButton.setText("Cancel");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.add(this.selectAllButton);
        jPanel2.add(this.deselectAllButton);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel3.add(this.diffButton);
        jPanel3.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private Component createFileChooserPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Primary Directory"));
        jPanel2.add((Component)this.primaryDirChooser, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new TitledBorder("Secondary Directory"));
        jPanel3.add((Component)this.secondaryDirChooser, "Center");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private Component createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Found IDB Pairs"));
        JScrollPane jScrollPane = new JScrollPane(this.diffsTable);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private String cutErrorMessage(String string) {
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 != -1) {
            n2 = string.indexOf("\n", n3);
            if (n3 == -1) continue;
            n3 = n2 + 1;
            if (++n4 < 16) continue;
            string2 = string.substring(0, n3);
            string2 = string2 + "...";
            return string2;
        }
        return string;
    }

    private void selectAll(boolean bl2) {
        IdbPairTableModel idbPairTableModel = this.diffsTable.getTableModel();
        List<DiffPairTableData> list = idbPairTableModel.getTableData();
        for (DiffPairTableData diffPairTableData : list) {
            diffPairTableData.getSelectionCheckBox().setSelected(bl2);
        }
        idbPairTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateSelectedDiffs() {
        String string = "";
        String string2 = "";
        String string3 = "";
        List<DiffPairTableData> list = this.getSelectedIdbPairs();
        if (list.size() == 0) {
            CMessageBox.showInformation(this, "Can't start diff process. There is no diff selected.");
            return false;
        }
        for (DiffPairTableData diffPairTableData : list) {
            String string4 = String.format("%s%s%s", this.workspacePath, File.separator, diffPairTableData.getDestinationDirectory());
            File file = new File(string4);
            try {
                if (!file.mkdir()) {
                    string = string + String.format(" - %s", string4 + "\n");
                }
            }
            catch (Exception exception) {
                string = string + String.format(" - %s", string4 + "\n");
            }
            finally {
                file.delete();
            }
            String string5 = diffPairTableData.getIDBLocation();
            if (!string5.endsWith(File.separator)) {
                string5 = string5 + File.separator;
            }
            String string6 = String.format("%s%s%s", this.getSourceBasePath(ESide.PRIMARY), string5, diffPairTableData.getIDBName());
            String string7 = String.format("%s%s%s", this.getSourceBasePath(ESide.SECONDARY), string5, diffPairTableData.getIDBName());
            File file2 = new File(string6);
            File file3 = new File(string7);
            if (!file2.exists()) {
                string2 = string2 + String.format(" - %s", string6 + "\n");
            }
            if (!file3.exists()) {
                string2 = string2 + String.format(" - %s", string7 + "\n");
            }
            if (!file.exists()) continue;
            string3 = string3 + String.format(" - %s", string4 + "\n");
        }
        string = this.cutErrorMessage(string);
        string2 = this.cutErrorMessage(string2);
        if (!(string3 = this.cutErrorMessage(string3)).equals("")) {
            string3 = String.format("%s\n\n%s", "Can't start diff process. Some diff destination folders already exist.\nPlease rename affected destination folders.", string3);
            CMessageBox.showInformation(this, string3);
            return false;
        }
        if (!string.equals("")) {
            string = String.format("%s\n\n%s", "Can't start diff process. Some destination folders cannot be created.", string);
            CMessageBox.showInformation(this, string);
            return false;
        }
        if (!string2.equals("")) {
            string2 = String.format("%s\n\n%s", "Can't start diff process. Can't find some source files.", string2);
            CMessageBox.showInformation(this, string2);
            return false;
        }
        return true;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add(this.createFileChooserPanel(), "North");
        jPanel.add(this.createTablePanel(), "Center");
        jPanel.add(this.createButtonsPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    public boolean getDiffButtonPressed() {
        return this.diffButtonPressed;
    }

    public List<DiffPairTableData> getSelectedIdbPairs() {
        ArrayList<DiffPairTableData> arrayList = new ArrayList<DiffPairTableData>();
        IdbPairTableModel idbPairTableModel = this.diffsTable.getTableModel();
        for (DiffPairTableData diffPairTableData : idbPairTableModel.getTableData()) {
            if (!diffPairTableData.getSelectionCheckBox().isSelected()) continue;
            arrayList.add(diffPairTableData);
        }
        return arrayList;
    }

    public String getSourceBasePath(ESide eSide) {
        return eSide == ESide.PRIMARY ? this.primaryDirChooser.getText() : this.secondaryDirChooser.getText();
    }

    private class InternalDirectoryChooserListener
    implements ActionListener {
        private InternalDirectoryChooserListener() {
        }

        private List<DiffPairTableData> findDiffPairs() {
            ArrayList<DiffPairTableData> arrayList = new ArrayList<DiffPairTableData>();
            File file = new File(DirectoryDiffDialog.this.primaryDirChooser.getText());
            File file2 = new File(DirectoryDiffDialog.this.secondaryDirChooser.getText());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("idb");
            arrayList2.add("i64");
            if (file.exists() && file2.exists()) {
                Object object;
                Iterator iterator;
                List<String> list = BinDiffFileUtils.findFiles(file, arrayList2);
                ArrayList arrayList3 = new ArrayList();
                for (String object22 : list) {
                    iterator = object22.substring(file.getPath().length());
                    arrayList3.add(iterator);
                }
                List<String> list2 = BinDiffFileUtils.findFiles(file2, arrayList2);
                HashSet<String> hashSet = new HashSet<String>();
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    object = string.substring(file2.getPath().length());
                    hashSet.add((String)object);
                }
                for (String string : arrayList3) {
                    if (!hashSet.contains(string)) continue;
                    object = new File(string);
                    String string2 = ((File)object).getName();
                    String string3 = ((File)object).getParent();
                    String string4 = String.format("%s%s%s", file, File.separator, string2);
                    String string5 = String.format("%s%s%s", file2, File.separator, string2);
                    String string6 = DiffDirectories.getDiffDestinationDirectoryName(string4, string5);
                    DiffPairTableData diffPairTableData = new DiffPairTableData(string2, string3, string6);
                    arrayList.add(diffPairTableData);
                }
            }
            return arrayList;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<DiffPairTableData> list = new ArrayList<DiffPairTableData>();
            if (actionEvent.getSource().equals(DirectoryDiffDialog.this.primaryDirChooser.getButton())) {
                File file = DirectoryDiffDialog.this.chooseFile(DirectoryDiffDialog.this, ESide.PRIMARY);
                if (file != null && file.exists()) {
                    DirectoryDiffDialog.this.primaryDirChooser.setText(file.getPath());
                }
                if (!DirectoryDiffDialog.this.secondaryDirChooser.getText().equals("")) {
                    list = this.findDiffPairs();
                }
            } else if (actionEvent.getSource().equals(DirectoryDiffDialog.this.secondaryDirChooser.getButton())) {
                File file = DirectoryDiffDialog.this.chooseFile(DirectoryDiffDialog.this, ESide.SECONDARY);
                if (file != null && file.exists()) {
                    DirectoryDiffDialog.this.secondaryDirChooser.setText(file.getPath());
                }
                if (!DirectoryDiffDialog.this.primaryDirChooser.getText().equals("")) {
                    list = this.findDiffPairs();
                }
            }
            DirectoryDiffDialog.this.diffsTable.setTableData(list);
        }
    }

    private class InternalButtonListener
    extends AbstractAction {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(DirectoryDiffDialog.this.selectAllButton)) {
                DirectoryDiffDialog.this.selectAll(true);
            } else if (actionEvent.getSource().equals(DirectoryDiffDialog.this.deselectAllButton)) {
                DirectoryDiffDialog.this.selectAll(false);
            } else if (actionEvent.getSource().equals(DirectoryDiffDialog.this.diffButton)) {
                if (DirectoryDiffDialog.this.diffsTable.isEditing()) {
                    DirectoryDiffDialog.this.diffsTable.getCellEditor().stopCellEditing();
                }
                if (!DirectoryDiffDialog.this.validateSelectedDiffs()) {
                    return;
                }
                DirectoryDiffDialog.this.diffButtonPressed = true;
                DirectoryDiffDialog.this.dispose();
            } else {
                DirectoryDiffDialog.this.diffButtonPressed = false;
                DirectoryDiffDialog.this.dispose();
            }
        }
    }
}

