/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.nodes;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.Criterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionType;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import java.util.Enumeration;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;

public abstract class AbstractCriterionTreeNode
extends IconNode {
    private final Criterion criterion;

    public AbstractCriterionTreeNode(Criterion criterion) {
        this.criterion = criterion;
    }

    private boolean allowAppendAndOrOperator() {
        CriterionType criterionType = this.getCriterion().getType();
        if (criterionType != CriterionType.NOT) {
            return true;
        }
        return this.getChildCount() == 0;
    }

    private boolean allowAppendCondition() {
        int n2 = this.getChildCount();
        CriterionType criterionType = this.getCriterion().getType();
        if (criterionType == CriterionType.CONDITION && this.isRoot() && n2 == 0) {
            return true;
        }
        if (criterionType != CriterionType.NOT) {
            return true;
        }
        return this.getChildCount() == 0;
    }

    private boolean allowAppendNotOperator() {
        CriterionType criterionType = this.getCriterion().getType();
        return criterionType != CriterionType.NOT;
    }

    private boolean allowInsertAndOrOperator() {
        return this.getChildCount() > 0;
    }

    private boolean allowInsertCondition() {
        return false;
    }

    private boolean allowInsertNotOperator() {
        CriterionType criterionType = this.getCriterion().getType();
        int n2 = this.getChildCount();
        if (criterionType != CriterionType.NOT && n2 == 1) {
            return ((AbstractCriterionTreeNode)this.children.get(0)).getCriterion().getType() != CriterionType.NOT;
        }
        return false;
    }

    public boolean allowAppend(CriterionType criterionType) {
        if (this.isRoot() && this.getChildCount() > 0) {
            return false;
        }
        if (this.getCriterion().getType() == CriterionType.CONDITION && !this.isRoot()) {
            return false;
        }
        if (criterionType == CriterionType.CONDITION) {
            return this.allowAppendCondition();
        }
        if (criterionType == CriterionType.AND || criterionType == CriterionType.OR) {
            return this.allowAppendAndOrOperator();
        }
        if (criterionType == CriterionType.NOT) {
            return this.allowAppendNotOperator();
        }
        return false;
    }

    public boolean allowInsert(CriterionType criterionType) {
        if (this.getCriterion().getType() == CriterionType.CONDITION && !this.isRoot()) {
            return false;
        }
        if (criterionType == CriterionType.CONDITION) {
            return this.allowInsertCondition();
        }
        if (criterionType == CriterionType.AND || criterionType == CriterionType.OR) {
            return this.allowInsertAndOrOperator();
        }
        if (criterionType == CriterionType.NOT) {
            return this.allowInsertNotOperator();
        }
        return true;
    }

    public void deleteChildren() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ((AbstractCriterionTreeNode)enumeration.nextElement()).deleteChildren();
        }
        this.removeAllChildren();
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public abstract JPopupMenu getPopupMenu();
}

