/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.menus;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionCreator;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionType;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.ExpressionTreeActionProvider;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.AddConditionAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.AppendAndOperatorAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.AppendNotOperatorAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.AppendOrOperatorAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.InsertAndOperatorAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.InsertNotOperatorAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.InsertOrOperatorAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.RemoveAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.actions.RemoveAllAction;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.nodes.CriterionTreeNode;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class NodeMenuBuilder {
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem insertAnd;
    private final JMenuItem insertOr;
    private final JMenuItem insertNot;
    private final JMenuItem appendAnd;
    private final JMenuItem appendOr;
    private final JMenuItem appendNot;
    private final JMenu conditionSubmenu;
    private final JMenuItem remove;
    private final JMenuItem removeAll;
    private final CriterionTreeNode criterionNode;

    public NodeMenuBuilder(CriterionTreeNode criterionTreeNode, List<CriterionCreator> list, ExpressionTreeActionProvider expressionTreeActionProvider) {
        this.criterionNode = criterionTreeNode;
        this.appendAnd = new JMenuItem(new AppendAndOperatorAction(expressionTreeActionProvider));
        this.appendOr = new JMenuItem(new AppendOrOperatorAction(expressionTreeActionProvider));
        this.appendNot = new JMenuItem(new AppendNotOperatorAction(expressionTreeActionProvider));
        this.popup.add(this.appendAnd);
        this.popup.add(this.appendOr);
        this.popup.add(this.appendNot);
        this.popup.add(new JSeparator());
        this.insertAnd = new JMenuItem(new InsertAndOperatorAction(expressionTreeActionProvider));
        this.insertOr = new JMenuItem(new InsertOrOperatorAction(expressionTreeActionProvider));
        this.insertNot = new JMenuItem(new InsertNotOperatorAction(expressionTreeActionProvider));
        this.popup.add(this.insertAnd);
        this.popup.add(this.insertOr);
        this.popup.add(this.insertNot);
        this.popup.add(new JSeparator());
        this.conditionSubmenu = new JMenu("Create Condition");
        for (CriterionCreator criterionCreator : list) {
            this.conditionSubmenu.add(new JMenuItem(new AddConditionAction(criterionCreator, expressionTreeActionProvider)));
        }
        this.popup.add(this.conditionSubmenu);
        this.popup.add(new JSeparator());
        this.remove = new JMenuItem(new RemoveAction(criterionTreeNode, expressionTreeActionProvider));
        this.popup.add(this.remove);
        this.popup.add(new JSeparator());
        this.removeAll = new JMenuItem(new RemoveAllAction(expressionTreeActionProvider));
        this.popup.add(this.removeAll);
    }

    private void updateMenuState() {
        this.appendAnd.setEnabled(this.criterionNode.allowAppend(CriterionType.AND));
        this.appendOr.setEnabled(this.criterionNode.allowAppend(CriterionType.OR));
        this.appendNot.setEnabled(this.criterionNode.allowAppend(CriterionType.NOT));
        this.insertAnd.setEnabled(this.criterionNode.allowInsert(CriterionType.AND));
        this.insertOr.setEnabled(this.criterionNode.allowInsert(CriterionType.OR));
        this.insertNot.setEnabled(this.criterionNode.allowInsert(CriterionType.NOT));
        this.conditionSubmenu.setEnabled(this.criterionNode.allowAppend(CriterionType.CONDITION));
        this.remove.setEnabled(!this.criterionNode.isRoot());
        this.removeAll.setEnabled(this.criterionNode.getChildCount() != 0);
    }

    public JPopupMenu getPopup() {
        this.updateMenuState();
        return this.popup;
    }
}

