/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionCreator;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.JCriterionTreeModel;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.TreeNodeRenderer;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.nodes.AbstractCriterionTreeNode;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JCriterionTree
extends JTree {
    private final InternalMouseListener mouseListener = new InternalMouseListener();
    private final JCriterionTreeModel model;
    private TreePath currentCriterionPath = null;

    public JCriterionTree(CriterionTree criterionTree, List<CriterionCreator> list) {
        this.model = new JCriterionTreeModel(this, criterionTree, list);
        this.setRootVisible(true);
        this.setModel(this.model);
        this.setCellRenderer(new TreeNodeRenderer());
        this.addMouseListener(this.mouseListener);
        this.updateUI();
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        AbstractCriterionTreeNode abstractCriterionTreeNode = (AbstractCriterionTreeNode)TreeHelpers.getNodeAt(this, mouseEvent.getX(), mouseEvent.getY());
        if (abstractCriterionTreeNode != null && (jPopupMenu = abstractCriterionTreeNode.getPopupMenu()) != null) {
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void delete() {
        this.removeMouseListener(this.mouseListener);
    }

    public TreePath getCurrentCriterionPath() {
        return this.currentCriterionPath;
    }

    @Override
    public JCriterionTreeModel getModel() {
        return this.model;
    }

    public void setCurrentCriterionPath(TreePath treePath) {
        this.currentCriterionPath = treePath;
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JCriterionTree.this.currentCriterionPath = JCriterionTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.isPopupTrigger()) {
                JCriterionTree.this.showPopupMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JCriterionTree.this.currentCriterionPath = JCriterionTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.isPopupTrigger()) {
                JCriterionTree.this.showPopupMenu(mouseEvent);
            }
        }
    }
}

