/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.Criterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.ICriterionListener;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.ICriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.JCriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.nodes.AbstractCriterionTreeNode;
import javax.swing.tree.TreePath;

public class ExpressionTreeActionProvider {
    private final JCriterionTree jtree;
    private final CriterionTree ctree;
    private final ICriterionListener internalCriterionListener = new InternalCriterionListener();

    public ExpressionTreeActionProvider(JCriterionTree jCriterionTree, CriterionTree criterionTree) {
        this.jtree = jCriterionTree;
        this.ctree = criterionTree;
        jCriterionTree.getModel().setActionProvider(this);
    }

    private static ICriterionTreeNode findNode(ICriterionTreeNode iCriterionTreeNode, Criterion criterion) {
        if (iCriterionTreeNode.getCriterion() == criterion) {
            return iCriterionTreeNode;
        }
        for (ICriterionTreeNode iCriterionTreeNode2 : iCriterionTreeNode.getChildren()) {
            ICriterionTreeNode iCriterionTreeNode3 = ExpressionTreeActionProvider.findNode(iCriterionTreeNode2, criterion);
            if (iCriterionTreeNode3 == null) continue;
            return iCriterionTreeNode3;
        }
        return null;
    }

    public void appendCriterion(Criterion criterion) {
        TreePath treePath = this.jtree.getCurrentCriterionPath();
        if (treePath == null) {
            return;
        }
        criterion.addListener(this.internalCriterionListener);
        AbstractCriterionTreeNode abstractCriterionTreeNode = (AbstractCriterionTreeNode)treePath.getLastPathComponent();
        ICriterionTreeNode iCriterionTreeNode = ExpressionTreeActionProvider.findNode(this.ctree.getRoot(), abstractCriterionTreeNode.getCriterion());
        this.ctree.appendNode(iCriterionTreeNode, new CriterionTreeNode(criterion));
    }

    public CriterionTree getCriterionTree() {
        return this.ctree;
    }

    public JCriterionTree getJTree() {
        return this.jtree;
    }

    public void insertCriterion(Criterion criterion) {
        TreePath treePath = this.jtree.getCurrentCriterionPath();
        if (treePath == null) {
            return;
        }
        criterion.addListener(this.internalCriterionListener);
        AbstractCriterionTreeNode abstractCriterionTreeNode = (AbstractCriterionTreeNode)treePath.getLastPathComponent();
        ICriterionTreeNode iCriterionTreeNode = ExpressionTreeActionProvider.findNode(this.ctree.getRoot(), abstractCriterionTreeNode.getCriterion());
        this.ctree.insertNode(iCriterionTreeNode, new CriterionTreeNode(criterion));
    }

    public void remove(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        AbstractCriterionTreeNode abstractCriterionTreeNode = (AbstractCriterionTreeNode)treePath.getLastPathComponent();
        ICriterionTreeNode iCriterionTreeNode = ExpressionTreeActionProvider.findNode(this.ctree.getRoot(), abstractCriterionTreeNode.getCriterion());
        this.ctree.removeNode(iCriterionTreeNode);
    }

    public void removeAll() {
        this.ctree.removeAll();
    }

    private class InternalCriterionListener
    implements ICriterionListener {
        private InternalCriterionListener() {
        }

        @Override
        public void criterionChanged() {
            ExpressionTreeActionProvider.this.jtree.updateUI();
        }
    }
}

