/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.root.RootCriterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.Criterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.ICriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.ICriterionTreeListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.logging.Level;

public class CriterionTree {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ListenerProvider<ICriterionTreeListener> listeners = new ListenerProvider();
    private final CriterionTreeNode rootNode = new CriterionTreeNode(new RootCriterion());

    public void addListener(ICriterionTreeListener iCriterionTreeListener) {
        this.listeners.addListener(iCriterionTreeListener);
    }

    public void appendNode(ICriterionTreeNode iCriterionTreeNode) {
        this.appendNode(this.rootNode, iCriterionTreeNode);
    }

    public void appendNode(ICriterionTreeNode iCriterionTreeNode, ICriterionTreeNode iCriterionTreeNode2) {
        CriterionTreeNode.append(iCriterionTreeNode, iCriterionTreeNode2);
        for (ICriterionTreeListener iCriterionTreeListener : this.listeners) {
            try {
                iCriterionTreeListener.nodeAppended(this, iCriterionTreeNode, iCriterionTreeNode2);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Append tree node");
            }
        }
    }

    public ICriterionTreeNode getRoot() {
        return this.rootNode;
    }

    public Criterion getRootCriterion() {
        return this.rootNode.getCriterion();
    }

    public void insertNode(ICriterionTreeNode iCriterionTreeNode) {
        this.insertNode(this.rootNode, iCriterionTreeNode);
    }

    public void insertNode(ICriterionTreeNode iCriterionTreeNode, ICriterionTreeNode iCriterionTreeNode2) {
        CriterionTreeNode.insert(iCriterionTreeNode, iCriterionTreeNode2);
        for (ICriterionTreeListener iCriterionTreeListener : this.listeners) {
            try {
                iCriterionTreeListener.nodeInserted(this, iCriterionTreeNode, iCriterionTreeNode2);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Insert tree node");
            }
        }
    }

    public void removeAll() {
        if (this.rootNode.getChildren().size() == 1) {
            this.removeNode(this.rootNode.getChildren().get(0));
        }
        for (ICriterionTreeListener iCriterionTreeListener : this.listeners) {
            try {
                iCriterionTreeListener.removedAll(this);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Remove all tree Nodes");
            }
        }
    }

    public void removeListener(ICriterionTreeListener iCriterionTreeListener) {
        this.listeners.removeListener(iCriterionTreeListener);
    }

    public void removeNode(ICriterionTreeNode iCriterionTreeNode) {
        CriterionTreeNode.remove(iCriterionTreeNode);
        ICriterionTreeNode iCriterionTreeNode2 = iCriterionTreeNode.getParent();
        iCriterionTreeNode2.getChildren().remove(iCriterionTreeNode);
        for (ICriterionTreeListener iCriterionTreeListener : this.listeners) {
            try {
                iCriterionTreeListener.nodeRemoved(this, iCriterionTreeNode);
            }
            catch (Exception exception) {
                ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Remove tree node");
            }
        }
    }
}

