/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion;

import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionType;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.ICriterionTreeNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CriterionExecutor {
    private CriterionExecutor() {
    }

    public static Set<ZyGraphNode<? extends CViewNode<?>>> execute(CriterionTree criterionTree, BinDiffGraph<? extends ZyGraphNode<? extends CViewNode<?>>, ?> binDiffGraph) {
        return new HashSet(CollectionHelpers.filter(binDiffGraph.getNodes(), new CriterionFilter(criterionTree)));
    }

    private static class CriterionFilter
    implements ICollectionFilter<ZyGraphNode<? extends CViewNode<?>>> {
        private final CriterionTree tree;

        public CriterionFilter(CriterionTree criterionTree) {
            this.tree = criterionTree;
        }

        private boolean qualifies(ICriterionTreeNode iCriterionTreeNode, ZyGraphNode<? extends CViewNode<?>> zyGraphNode) {
            List<ICriterionTreeNode> list = iCriterionTreeNode.getChildren();
            if (iCriterionTreeNode.equals(this.tree.getRoot())) {
                if (list.size() != 1) {
                    throw new IllegalStateException("Root node has more or less than one child criterion.");
                }
                return this.qualifies(list.get(0), zyGraphNode);
            }
            if (iCriterionTreeNode.getCriterion().getType() == CriterionType.AND) {
                if (list.size() < 2) {
                    throw new IllegalStateException("AND operator has less than two child criteria.");
                }
                for (ICriterionTreeNode iCriterionTreeNode2 : iCriterionTreeNode.getChildren()) {
                    if (this.qualifies(iCriterionTreeNode2, zyGraphNode)) continue;
                    return false;
                }
                return true;
            }
            if (iCriterionTreeNode.getCriterion().getType() == CriterionType.OR) {
                if (list.size() < 2) {
                    throw new IllegalStateException("AND operator has less than two child criteria.");
                }
                for (ICriterionTreeNode iCriterionTreeNode3 : iCriterionTreeNode.getChildren()) {
                    if (!this.qualifies(iCriterionTreeNode3, zyGraphNode)) continue;
                    return true;
                }
                return false;
            }
            if (iCriterionTreeNode.getCriterion().getType() == CriterionType.NOT) {
                if (list.size() != 1) {
                    throw new IllegalStateException("NOT operator has more or less than one child criterion.");
                }
                return !this.qualifies(list.get(0), zyGraphNode);
            }
            if (iCriterionTreeNode instanceof CriterionTreeNode) {
                CriterionTreeNode criterionTreeNode = (CriterionTreeNode)iCriterionTreeNode;
                return criterionTreeNode.getCriterion().matches(zyGraphNode);
            }
            throw new IllegalStateException("Unknown criterion.");
        }

        @Override
        public boolean qualifies(ZyGraphNode<? extends CViewNode<?>> zyGraphNode) {
            return this.qualifies(this.tree.getRoot(), zyGraphNode);
        }
    }
}

