/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.text;

import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.text.TextCriterion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class TextCriterionPanel
extends JPanel {
    private final JTextField inputField = TextComponentUtils.addDefaultEditorActions(new JTextField(""));
    private final JCheckBox caseSensitiveBox = new JCheckBox("Case Sensitive");
    private final JCheckBox regExBox = new JCheckBox("Regular Expression");
    private final TextCriterion criterion;

    public TextCriterionPanel(TextCriterion textCriterion) {
        super(new BorderLayout());
        this.criterion = textCriterion;
        this.initPanel();
    }

    private void initPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Edit Text Condition"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.inputField.addKeyListener(new InternalTextListener());
        this.inputField.setPreferredSize(new Dimension(this.inputField.getPreferredSize().width, 23));
        jPanel2.add((Component)this.inputField, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.setBorder(new EmptyBorder(5, 0, 0, 0));
        jPanel3.add(this.caseSensitiveBox);
        jPanel3.add(this.regExBox);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
    }

    public String getText() {
        return this.inputField.getText();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitiveBox.isSelected();
    }

    public boolean isRegularExpression() {
        return this.regExBox.isSelected();
    }

    private class InternalTextListener
    implements KeyListener {
        private InternalTextListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            TextCriterionPanel.this.criterion.update();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            TextCriterionPanel.this.criterion.update();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            TextCriterionPanel.this.criterion.update();
        }
    }
}

