/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.outdegree;

import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.outdegree.OutDegreeCriterion;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class OutDegreeCriterionPanel
extends JPanel {
    private final OutDegreeCriterion criterion;
    private final JFormattedTextField inputField = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CDecFormatter(8)));
    private final JComboBox<String> operatorBox = new JComboBox();
    private final InternalComboboxListener comboboxListener = new InternalComboboxListener();
    private final InternalTextListener textFieldListener = new InternalTextListener();

    public OutDegreeCriterionPanel(OutDegreeCriterion outDegreeCriterion) {
        super(new BorderLayout());
        this.criterion = outDegreeCriterion;
        this.operatorBox.addActionListener(this.comboboxListener);
        this.inputField.addKeyListener(this.textFieldListener);
        this.initPanel();
    }

    private void initPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Edit Out-degree Condition"));
        this.operatorBox.addItem("<");
        this.operatorBox.addItem("=");
        this.operatorBox.addItem(">");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(5, 0, 5, 5));
        jPanel2.add(this.operatorBox, "Center");
        jPanel3.add((Component)this.inputField, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "West");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "North");
        this.add((Component)jPanel, "Center");
    }

    public void delete() {
        this.operatorBox.removeActionListener(this.comboboxListener);
        this.inputField.removeKeyListener(this.textFieldListener);
    }

    public String getOperator() {
        return this.operatorBox.getSelectedItem().toString();
    }

    public int getOutDegree() {
        return this.inputField.getText().isEmpty() ? 0 : Integer.parseInt(this.inputField.getText());
    }

    private class InternalTextListener
    implements KeyListener {
        private InternalTextListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            OutDegreeCriterionPanel.this.criterion.update();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            OutDegreeCriterionPanel.this.criterion.update();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            OutDegreeCriterionPanel.this.criterion.update();
        }
    }

    private class InternalComboboxListener
    implements ActionListener {
        private InternalComboboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OutDegreeCriterionPanel.this.criterion.update();
        }
    }
}

