/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.outdegree;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.ConditionCriterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.outdegree.OutDegreeCriterionPanel;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class OutDegreeCriterion
extends ConditionCriterion {
    private static final ImageIcon OUTDEGREE_CONDITION_ICON = ImageUtils.getImageIcon("data/selectbycriteriaicons/outdegree-condition.png");
    private final OutDegreeCriterionPanel panel = new OutDegreeCriterionPanel(this);

    @Override
    public String getCriterionDescription() {
        return String.format("Nodes with Outdegree %s %d", this.getOperator(), this.getOutDegree());
    }

    @Override
    public JPanel getCriterionPanel() {
        return this.panel;
    }

    @Override
    public Icon getIcon() {
        return OUTDEGREE_CONDITION_ICON;
    }

    public String getOperator() {
        return this.panel.getOperator();
    }

    public int getOutDegree() {
        return this.panel.getOutDegree();
    }

    @Override
    public boolean matches(ZyGraphNode<? extends CViewNode<?>> zyGraphNode) {
        String string = this.panel.getOperator();
        CViewNode<?> cViewNode = zyGraphNode.getRawNode();
        if (string.equals("<")) {
            return cViewNode.getOutgoingEdges().size() < this.getOutDegree();
        }
        if (string.equals("=")) {
            return cViewNode.getOutgoingEdges().size() == this.getOutDegree();
        }
        if (string.equals(">")) {
            return cViewNode.getOutgoingEdges().size() > this.getOutDegree();
        }
        return false;
    }

    public void update() {
        this.notifyListeners();
    }
}

