/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.nodecolor;

import com.google.security.zynamics.bindiff.graph.AbstractGraphsContainer;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.nodecolor.ColorCriterion;
import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import com.google.security.zynamics.zylib.gui.ColorPanel.IColorPanelListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ColorCriterionPanel
extends JPanel {
    private final ColorPanel selectedColorPanel;
    private final ColorCriterion colorCriterion;
    private final List<ColorPanel> colorPanels = new ArrayList<ColorPanel>();
    private final InternalColorPanelListener colorPanelListener = new InternalColorPanelListener();

    public ColorCriterionPanel(ColorCriterion colorCriterion) {
        super(new BorderLayout());
        this.colorCriterion = colorCriterion;
        this.selectedColorPanel = new ColorPanel(null, false);
        this.selectedColorPanel.addListener(this.colorPanelListener);
        this.selectedColorPanel.addMouseListener(this.colorPanelListener);
    }

    private void createPanel(List<Color> list) {
        this.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Edit Color Condition"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 5, 3, 5));
        jPanel2.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1 + list.size() / 4, 4));
        jPanel3.setBorder(new TitledBorder(""));
        for (Color color : list) {
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(new EmptyBorder(3, 3, 3, 3));
            ColorPanel colorPanel = new ColorPanel(color, false);
            jPanel4.add((Component)colorPanel, "Center");
            this.colorPanels.add(colorPanel);
            colorPanel.addListener(this.colorPanelListener);
            colorPanel.addMouseListener(this.colorPanelListener);
            jPanel3.add((Component)jPanel4, "North");
        }
        this.selectedColorPanel.setColor(list.size() > 0 ? list.get(0) : Color.WHITE);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel3, "North");
        jPanel5.setBorder(new EmptyBorder(3, 5, 0, 5));
        jPanel.add((Component)jPanel5, "Center");
        this.add((Component)jPanel, "Center");
    }

    private void getColors(Set<Color> set, AbstractZyGraph<? extends ZyGraphNode<?>, ?> abstractZyGraph) {
        for (ZyGraphNode<?> zyGraphNode : abstractZyGraph.getNodes()) {
            set.add(zyGraphNode.getRealizer().getFillColor());
        }
    }

    public void delete() {
        this.selectedColorPanel.removeListener(this.colorPanelListener);
        this.selectedColorPanel.removeMouseListener(this.colorPanelListener);
        for (ColorPanel colorPanel : this.colorPanels) {
            colorPanel.removeListener(this.colorPanelListener);
            colorPanel.removeMouseListener(this.colorPanelListener);
        }
    }

    public Color getColor() {
        return this.selectedColorPanel.getColor();
    }

    public void updateColors(AbstractGraphsContainer abstractGraphsContainer) {
        HashSet<Color> hashSet = new HashSet<Color>();
        this.getColors(hashSet, abstractGraphsContainer.getPrimaryGraph());
        this.getColors(hashSet, abstractGraphsContainer.getSecondaryGraph());
        this.getColors(hashSet, abstractGraphsContainer.getCombinedGraph());
        this.createPanel(new ArrayList<Color>(hashSet));
    }

    private class InternalColorPanelListener
    extends MouseAdapter
    implements IColorPanelListener {
        private InternalColorPanelListener() {
        }

        @Override
        public void changedColor(ColorPanel colorPanel) {
            ColorCriterionPanel.this.colorCriterion.update();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ColorPanel colorPanel;
            Color color;
            if (mouseEvent.getButton() == 1 && (color = (colorPanel = (ColorPanel)mouseEvent.getSource()).getColor()) != null) {
                ColorCriterionPanel.this.selectedColorPanel.setColor(color);
            }
        }
    }
}

