/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.nodecolor;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.AbstractGraphsContainer;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.ConditionCriterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.nodecolor.ColorCriterionPanel;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ColorCriterion
extends ConditionCriterion {
    private static final ImageIcon COLOR_CONDITION_ICON = ImageUtils.getImageIcon("data/selectbycriteriaicons/color-condition.png");
    private final ColorCriterionPanel panel;
    private final AbstractGraphsContainer graphs;

    public ColorCriterion(AbstractGraphsContainer abstractGraphsContainer) {
        Preconditions.checkNotNull(abstractGraphsContainer);
        this.panel = new ColorCriterionPanel(this);
        this.graphs = abstractGraphsContainer;
    }

    private JPanel getCriterionPanel(AbstractGraphsContainer abstractGraphsContainer) {
        this.panel.updateColors(abstractGraphsContainer);
        return this.panel;
    }

    @Override
    public JPanel getCriterionPanel() {
        return this.getCriterionPanel(this.graphs);
    }

    public Color getColor() {
        return this.panel.getColor();
    }

    @Override
    public String getCriterionDescription() {
        return String.format("Nodes with Color %06X", this.getColor().getRGB() & 0xFFFFFF);
    }

    @Override
    public Icon getIcon() {
        return COLOR_CONDITION_ICON;
    }

    @Override
    public boolean matches(ZyGraphNode<? extends CViewNode<?>> zyGraphNode) {
        return zyGraphNode.getRawNode().getColor().equals(this.getColor());
    }

    public void update() {
        this.notifyListeners();
    }
}

