/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.indegrees;

import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.indegrees.InDegreeCriterion;
import com.google.security.zynamics.zylib.gui.CDecFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class InDegreeCriterionPanel
extends JPanel {
    private final InDegreeCriterion criterion;
    private final JFormattedTextField inputField = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CDecFormatter(8)));
    private final JComboBox<String> operatorBox = new JComboBox();
    private final InternalComboboxListener comboboxListener = new InternalComboboxListener();
    private final InternalTextListener textFieldListener = new InternalTextListener();

    public InDegreeCriterionPanel(InDegreeCriterion inDegreeCriterion) {
        super(new BorderLayout());
        this.criterion = inDegreeCriterion;
        this.operatorBox.addActionListener(this.comboboxListener);
        this.inputField.addKeyListener(this.textFieldListener);
        this.initPanel();
    }

    private void initPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Edit Indegree Condition"));
        this.operatorBox.addItem("<");
        this.operatorBox.addItem("=");
        this.operatorBox.addItem(">");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.add(this.operatorBox, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(5, 0, 5, 5));
        jPanel3.add((Component)this.inputField, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "West");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "North");
        this.add((Component)jPanel, "Center");
    }

    public void delete() {
        this.operatorBox.removeActionListener(this.comboboxListener);
        this.inputField.removeKeyListener(this.textFieldListener);
    }

    public int getIndegree() {
        return this.inputField.getText().isEmpty() ? 0 : Integer.parseInt(this.inputField.getText());
    }

    public String getOperator() {
        return this.operatorBox.getSelectedItem().toString();
    }

    private class InternalTextListener
    implements KeyListener {
        private InternalTextListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            InDegreeCriterionPanel.this.criterion.update();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            InDegreeCriterionPanel.this.criterion.update();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            InDegreeCriterionPanel.this.criterion.update();
        }
    }

    private class InternalComboboxListener
    implements ActionListener {
        private InternalComboboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InDegreeCriterionPanel.this.criterion.update();
        }
    }
}

