/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.indegrees;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.ConditionCriterion;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.conditions.indegrees.InDegreeCriterionPanel;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class InDegreeCriterion
extends ConditionCriterion {
    private static final ImageIcon INDEGREE_CONDITION_ICON = ImageUtils.getImageIcon("data/selectbycriteriaicons/indegree-condition.png");
    private final InDegreeCriterionPanel panel = new InDegreeCriterionPanel(this);

    @Override
    public String getCriterionDescription() {
        return String.format("Nodes with Indegree %s %d", this.getOperator(), this.getIndegree());
    }

    @Override
    public JPanel getCriterionPanel() {
        return this.panel;
    }

    @Override
    public Icon getIcon() {
        return INDEGREE_CONDITION_ICON;
    }

    public int getIndegree() {
        return this.panel.getIndegree();
    }

    public String getOperator() {
        return this.panel.getOperator();
    }

    @Override
    public boolean matches(ZyGraphNode<? extends CViewNode<?>> zyGraphNode) {
        String string = this.panel.getOperator();
        CViewNode<?> cViewNode = zyGraphNode.getRawNode();
        if (string.equals("<")) {
            return cViewNode.getIncomingEdges().size() < this.getIndegree();
        }
        if (string.equals("=")) {
            return cViewNode.getIncomingEdges().size() == this.getIndegree();
        }
        if (string.equals(">")) {
            return cViewNode.getIncomingEdges().size() > this.getIndegree();
        }
        return false;
    }

    public void update() {
        this.notifyListeners();
    }
}

