/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog;

import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.criterion.CriterionType;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.CriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressionmodel.ICriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.ExpressionTreeValidator;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.ICriterionTreeListener;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.JCriterionTree;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.nodes.AbstractCriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.expressiontree.nodes.CriterionTreeNode;
import com.google.security.zynamics.bindiff.gui.dialogs.criteriadialog.operators.AbstractOperatorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DialogUpdater {
    private static final Color INVALID_OPERATOR_COLOR = new Color(160, 0, 0);
    private static final Color VALID_OPERATOR_COLOR = new Color(0, 0, 0);
    private final JCriterionTree jtree;
    private final InternalTreeSelectionListener treeSelectionListener = new InternalTreeSelectionListener();
    private final InternalCriterionTreeListener treeCriterionListener = new InternalCriterionTreeListener();
    private final CriterionTree ctree;
    private final JPanel defineConditionPanel;
    private final JButton addConditionButton;
    private final JButton okButton;

    public DialogUpdater(JCriterionTree jCriterionTree, CriterionTree criterionTree, JPanel jPanel, JButton jButton, JButton jButton2) {
        this.jtree = jCriterionTree;
        this.ctree = criterionTree;
        this.defineConditionPanel = jPanel;
        this.addConditionButton = jButton;
        this.okButton = jButton2;
        this.jtree.addTreeSelectionListener(this.treeSelectionListener);
        this.ctree.addListener(this.treeCriterionListener);
    }

    private void updateDefineConditionPanel(AbstractCriterionTreeNode abstractCriterionTreeNode) {
        JPanel jPanel = null;
        if (abstractCriterionTreeNode instanceof CriterionTreeNode) {
            jPanel = abstractCriterionTreeNode.getCriterion().getCriterionPanel();
        }
        this.defineConditionPanel.removeAll();
        this.defineConditionPanel.setBorder(null);
        if (jPanel != null) {
            this.defineConditionPanel.add(jPanel);
        } else {
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new TitledBorder("Define Condition"));
            this.defineConditionPanel.add((Component)jPanel2, "Center");
        }
        this.defineConditionPanel.updateUI();
    }

    public void delete() {
        this.jtree.removeTreeSelectionListener(this.treeSelectionListener);
        this.ctree.removeListener(this.treeCriterionListener);
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            if (treePath == null) {
                DialogUpdater.this.addConditionButton.setEnabled(false);
                DialogUpdater.this.updateDefineConditionPanel((AbstractCriterionTreeNode)DialogUpdater.this.jtree.getModel().getRoot());
            } else {
                AbstractCriterionTreeNode abstractCriterionTreeNode;
                AbstractCriterionTreeNode abstractCriterionTreeNode2 = (AbstractCriterionTreeNode)treePath.getLastPathComponent();
                boolean bl2 = abstractCriterionTreeNode2.allowAppend(CriterionType.CONDITION);
                if (!bl2 && abstractCriterionTreeNode2.getLevel() > 0 && (abstractCriterionTreeNode = (AbstractCriterionTreeNode)abstractCriterionTreeNode2.getParent()).getLevel() != 0 && abstractCriterionTreeNode.getCriterion().getType() != CriterionType.NOT && abstractCriterionTreeNode2.getCriterion().getType() != CriterionType.NOT) {
                    bl2 = true;
                }
                DialogUpdater.this.addConditionButton.setEnabled(bl2);
                DialogUpdater.this.updateDefineConditionPanel(abstractCriterionTreeNode2);
            }
        }
    }

    private class InternalCriterionTreeListener
    implements ICriterionTreeListener {
        private InternalCriterionTreeListener() {
        }

        private void update() {
            this.updateInfoField();
            DialogUpdater.this.okButton.setEnabled(ExpressionTreeValidator.isValid(DialogUpdater.this.jtree));
        }

        private void updateCurrentCriterionPath() {
            if (DialogUpdater.this.jtree.getSelectionPath() != null) {
                DialogUpdater.this.jtree.setCurrentCriterionPath(DialogUpdater.this.jtree.getSelectionPath());
            } else {
                DialogUpdater.this.jtree.setCurrentCriterionPath(DialogUpdater.this.jtree.getPathForRow(0));
            }
            DialogUpdater.this.updateDefineConditionPanel((AbstractCriterionTreeNode)DialogUpdater.this.jtree.getCurrentCriterionPath().getLastPathComponent());
        }

        private void updateInfoField() {
            Enumeration<TreeNode> enumeration = ((AbstractCriterionTreeNode)DialogUpdater.this.jtree.getModel().getRoot()).breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                AbstractCriterionTreeNode abstractCriterionTreeNode = (AbstractCriterionTreeNode)enumeration.nextElement();
                JPanel jPanel = abstractCriterionTreeNode.getCriterion().getCriterionPanel();
                if (jPanel instanceof AbstractOperatorPanel) {
                    int n2 = abstractCriterionTreeNode.getChildCount();
                    CriterionType criterionType = abstractCriterionTreeNode.getCriterion().getType();
                    JTextArea jTextArea = ((AbstractOperatorPanel)jPanel).getInfoField();
                    if (n2 == 1 && (criterionType == CriterionType.NOT || abstractCriterionTreeNode.getLevel() == 0) || n2 > 1 && criterionType != CriterionType.NOT) {
                        jTextArea.setForeground(VALID_OPERATOR_COLOR);
                        jTextArea.setText(((AbstractOperatorPanel)jPanel).getValidInfoString());
                    } else {
                        jTextArea.setForeground(INVALID_OPERATOR_COLOR);
                        jTextArea.setText(((AbstractOperatorPanel)jPanel).getInvalidInfoString());
                    }
                }
                jPanel.updateUI();
            }
        }

        @Override
        public void nodeAppended(CriterionTree criterionTree, ICriterionTreeNode iCriterionTreeNode, ICriterionTreeNode iCriterionTreeNode2) {
            this.update();
        }

        @Override
        public void nodeInserted(CriterionTree criterionTree, ICriterionTreeNode iCriterionTreeNode, ICriterionTreeNode iCriterionTreeNode2) {
            this.update();
        }

        @Override
        public void nodeRemoved(CriterionTree criterionTree, ICriterionTreeNode iCriterionTreeNode) {
            this.updateCurrentCriterionPath();
            this.update();
        }

        @Override
        public void removedAll(CriterionTree criterionTree) {
            this.updateCurrentCriterionPath();
            this.update();
        }
    }
}

