/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.MessageBox;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.gui.dialogs.ProgressDialog;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanelManager;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.window.MainWindow;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.project.WorkspaceLoader;
import com.google.security.zynamics.bindiff.project.diff.Diff;
import com.google.security.zynamics.bindiff.project.matches.DiffMetadata;
import com.google.security.zynamics.bindiff.utils.BinDiffFileUtils;
import com.google.security.zynamics.zylib.gui.CFilenameFormatter;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.io.FileUtils;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SaveFunctionDiffViewDialog
extends BaseDialog {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final Color NORMAL_COLOR = new JFormattedTextField().getBackground();
    private static final Color OVERWRITE_INDICATION_COLOR = new Color(233, 200, 200);
    private static final int DIALOG_WIDTH = 650;
    private static final int DIALOG_HEIGHT = 190;
    private static final String FUNCTION_DIFF_VIEWS_DIRECTORY_NAME = "Function Diff Views";
    private final JFormattedTextField diffDatabaseFileName = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CFilenameFormatter(new File(SystemHelpers.getApplicationDataDirectory()))));
    private final JFormattedTextField primaryExportFileName = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CFilenameFormatter(new File(SystemHelpers.getApplicationDataDirectory()))));
    private final JFormattedTextField secondaryExportFileName = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CFilenameFormatter(new File(SystemHelpers.getApplicationDataDirectory()))));
    private final JCheckBox diffDatabaseOverwrite = new JCheckBox("Overwrite");
    private final JCheckBox primaryExportOverwrite = new JCheckBox("Overwrite");
    private final JCheckBox secondaryExportOverwrite = new JCheckBox("Overwrite");
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Cancel");
    private final DocumentListener documentListener = new InternalDocumentListener();
    private final ActionListener checkBoxListener = new InternalCheckboxListener();
    private final ActionListener buttonListener = new InternalButtonListener();
    private boolean okPressed = false;
    private final MainWindow window;
    private final Workspace workspace;
    private final Diff diff;
    private File destinationDir = null;
    private final Map<String, String> exportFilePathToMd5 = new HashMap<String, String>();

    public SaveFunctionDiffViewDialog(MainWindow mainWindow, String string, Workspace workspace, Diff diff) {
        super((Window)Preconditions.checkNotNull(mainWindow), string);
        this.window = mainWindow;
        this.workspace = Preconditions.checkNotNull(workspace);
        this.diff = Preconditions.checkNotNull(diff);
        this.init();
        this.diffDatabaseOverwrite.setEnabled(false);
        this.primaryExportOverwrite.setEnabled(false);
        this.secondaryExportOverwrite.setEnabled(false);
        this.diffDatabaseFileName.getDocument().addDocumentListener(this.documentListener);
        this.primaryExportFileName.getDocument().addDocumentListener(this.documentListener);
        this.secondaryExportFileName.getDocument().addDocumentListener(this.documentListener);
        this.diffDatabaseOverwrite.addActionListener(this.checkBoxListener);
        this.primaryExportOverwrite.addActionListener(this.checkBoxListener);
        this.secondaryExportOverwrite.addActionListener(this.checkBoxListener);
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(7, 5, 5, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private boolean createDestinationDirectory() {
        DiffMetadata diffMetadata = this.diff.getMetadata();
        String string = String.format("%s vs %s", diffMetadata.getImageName(ESide.PRIMARY), diffMetadata.getImageName(ESide.SECONDARY));
        String string2 = " - ";
        String string3 = String.format("%s-%s", diffMetadata.getImageHash(ESide.PRIMARY), diffMetadata.getImageHash(ESide.SECONDARY));
        int n2 = string.length() + " - ".length() + string3.length();
        if (n2 > 254) {
            int n3 = n2 - 254;
            string = string.substring(0, string.length() - 1 - n3);
        }
        String string4 = FileUtils.ensureTrailingSlash(this.destinationDir.getPath());
        string4 = string4 + String.format("%s%s%s", string, " - ", string3);
        this.destinationDir = new File(string4);
        if (!this.destinationDir.exists()) {
            return this.destinationDir.mkdir();
        }
        return true;
    }

    private JPanel createFilenameLinePanel(String string, JFormattedTextField jFormattedTextField, String string2, JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(150, 25));
        jLabel.setMaximumSize(new Dimension(150, 25));
        jPanel2.add((Component)jLabel, "West");
        jFormattedTextField.setPreferredSize(new Dimension(250, 25));
        jPanel2.add((Component)jFormattedTextField, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setPreferredSize(new Dimension(65, 25));
        jLabel2.setMaximumSize(new Dimension(65, 25));
        jPanel3.add((Component)jLabel2, "West");
        jPanel3.add((Component)jCheckBox, "Center");
        jPanel2.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel createFilenamePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 5, 5, 5), new TitledBorder("")));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 5, 5));
        jPanel2.add(this.createFilenameLinePanel("Diff Name:", this.diffDatabaseFileName, ".BinDiff", this.diffDatabaseOverwrite));
        jPanel2.add(this.createFilenameLinePanel("Primary Export Name:", this.primaryExportFileName, ".BinExport", this.primaryExportOverwrite));
        jPanel2.add(this.createFilenameLinePanel("Secondary Export Name:", this.secondaryExportFileName, ".BinExport", this.secondaryExportOverwrite));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private boolean createSingleViewsDirectory() {
        String string = this.workspace.getWorkspaceFile().getParentFile().getPath();
        string = FileUtils.ensureTrailingSlash(string);
        string = string + FUNCTION_DIFF_VIEWS_DIRECTORY_NAME;
        this.destinationDir = new File(string);
        if (!this.destinationDir.exists()) {
            return this.destinationDir.mkdir();
        }
        return true;
    }

    private void loadWorkspace() {
        if (!this.workspace.isLoaded()) {
            Serializable serializable;
            int n2;
            String string = BinDiffConfig.getInstance().getMainSettings().getDefaultWorkspace();
            boolean bl2 = false;
            if (new File(string).exists()) {
                n2 = MessageBox.showYesNoCancelQuestion(this.getParent(), "A workspace has to be loaded to save a function diff view. Load the default workspace?");
                if (n2 == 0) {
                    serializable = new File(string);
                    WorkspaceLoader workspaceLoader = new WorkspaceLoader((File)serializable, this.workspace);
                    try {
                        ProgressDialog.show((Window)this.getParent(), String.format("Loading Workspace '%s'", ((File)serializable).getName()), workspaceLoader);
                    }
                    catch (Exception exception) {
                        ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Load default workspace failed: '%s'", ((File)serializable).getPath());
                        MessageBox.showError(this.getParent(), String.format("Failed to load the current default workspace.\n'%s'", ((File)serializable).getPath()));
                    }
                } else if (n2 == 1) {
                    bl2 = true;
                }
            }
            if (bl2 || !new File(string).exists()) {
                if (!new File(string).exists() && (n2 = MessageBox.showYesNoQuestion(this.window, "A workspace has to be loaded to save a function diff view. Load workspace?")) == 1) {
                    return;
                }
                try {
                    TabPanelManager tabPanelManager = this.window.getController().getTabPanelManager();
                    serializable = tabPanelManager.getWorkspaceTabPanel();
                    ((WorkspaceTabPanel)serializable).getController().loadWorkspace();
                }
                catch (Exception exception) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("Load workspace failed");
                    MessageBox.showError(this.window, "Load workspace failed.");
                }
            }
        }
    }

    private void setDefaultNames() {
        String string = ((TabPanel)this.window.getController().getTabPanelManager().getTabbedPane().getSelectedComponent()).getTitle();
        this.setDefaultText(this.diffDatabaseFileName, string);
        String string2 = this.diff.getExportFile(ESide.PRIMARY).getName();
        string2 = BinDiffFileUtils.forceFilenameEndsNotWithExtension(string2, "BinExport");
        this.setDefaultText(this.primaryExportFileName, string2);
        String string3 = this.diff.getExportFile(ESide.SECONDARY).getName();
        string3 = BinDiffFileUtils.forceFilenameEndsNotWithExtension(string3, "BinExport");
        this.setDefaultText(this.secondaryExportFileName, string3);
        this.updateFileOverwriteIndicator();
    }

    private void setDefaultText(JFormattedTextField jFormattedTextField, String string) {
        String string2 = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            String string3 = jFormattedTextField.getText();
            string3 = string3.equals("") ? string2 + string.charAt(i2) : string3 + string.charAt(i2);
            jFormattedTextField.setText(string3);
            if (jFormattedTextField.getText().equals("")) continue;
            string2 = string3;
        }
    }

    private void updateFileOverwriteIndicator() {
        boolean bl2 = this.getMatchesDatabaseTargetFile().exists();
        this.diffDatabaseFileName.setBackground(bl2 ? OVERWRITE_INDICATION_COLOR : NORMAL_COLOR);
        this.diffDatabaseOverwrite.setEnabled(bl2);
        bl2 = this.getExportBinaryTargetFile(ESide.PRIMARY).exists() && !this.validateExportName(ESide.PRIMARY);
        this.primaryExportFileName.setBackground(bl2 ? OVERWRITE_INDICATION_COLOR : NORMAL_COLOR);
        this.primaryExportOverwrite.setEnabled(bl2);
        this.primaryExportOverwrite.setSelected(bl2 && this.primaryExportOverwrite.isSelected());
        bl2 = this.getExportBinaryTargetFile(ESide.SECONDARY).exists() && !this.validateExportName(ESide.SECONDARY);
        this.secondaryExportFileName.setBackground(bl2 ? OVERWRITE_INDICATION_COLOR : NORMAL_COLOR);
        this.secondaryExportOverwrite.setEnabled(bl2);
        this.secondaryExportOverwrite.setSelected(bl2 && this.secondaryExportOverwrite.isSelected());
    }

    private boolean validateDiffName() {
        File file = this.getMatchesDatabaseTargetFile();
        return !file.exists() || this.diffDatabaseOverwrite.isSelected();
    }

    private boolean validateExportName(ESide eSide) {
        File file = this.getExportBinaryTargetFile(eSide);
        if (file.exists()) {
            String string = this.diff.getBinExportMD5(eSide);
            String string2 = this.exportFilePathToMd5.get(file.getPath());
            if (string2 == null) {
                string2 = FileUtils.calcMD5(file);
                this.exportFilePathToMd5.put(file.getPath(), string2);
            }
            if (!string2.equals(string)) {
                if (eSide == ESide.PRIMARY && !this.primaryExportOverwrite.isSelected()) {
                    return false;
                }
                return eSide != ESide.SECONDARY || this.secondaryExportOverwrite.isSelected();
            }
        }
        return true;
    }

    private boolean validateInput() {
        if (!this.validateViewWithSameNameIsAlreadyOpen()) {
            MessageBox.showError(this, "There is already another view with the same diff name open. Close open view first or rename diff.");
            return false;
        }
        if (!this.validateDiffName()) {
            MessageBox.showError(this, String.format("A BinDiff file with the name '%s' already exists.\nRename or select the checkbox to override.", this.getMatchesDatabaseTargetFile().getName()));
            return false;
        }
        if (!this.validateExportName(ESide.PRIMARY)) {
            MessageBox.showError(this, String.format("A primary BinExport file named '%s' already exists with different content.\nRename or select the checkbox for override.", this.getExportBinaryTargetFile(ESide.PRIMARY).getName()));
            return false;
        }
        if (!this.validateExportName(ESide.SECONDARY)) {
            MessageBox.showError(this, String.format("A secondary BinExport file named '%s' already exists with different content.\nRename or select the checkbox for override.", this.getExportBinaryTargetFile(ESide.SECONDARY).getName()));
            return false;
        }
        return true;
    }

    private boolean validateViewWithSameNameIsAlreadyOpen() {
        for (Diff diff : this.workspace.getDiffList()) {
            if (!diff.getMatchesDatabase().equals(this.getMatchesDatabaseTargetFile()) || this.diff == diff) continue;
            return diff.getViewManager().getFlowGraphViewsData().size() == 0;
        }
        return true;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.createFilenamePanel(), "North");
        jPanel.add((Component)this.createButtonPanel(), "South");
        this.add((Component)jPanel, "Center");
        this.pack();
        this.setPreferredSize(new Dimension(650, 190));
        this.setMinimumSize(new Dimension(650, 190));
        GuiHelper.centerChildToParent(this.getParent(), this, true);
    }

    @Override
    public void dispose() {
        this.diffDatabaseFileName.getDocument().removeDocumentListener(this.documentListener);
        this.primaryExportFileName.getDocument().removeDocumentListener(this.documentListener);
        this.secondaryExportFileName.getDocument().removeDocumentListener(this.documentListener);
        this.diffDatabaseOverwrite.removeActionListener(this.checkBoxListener);
        this.primaryExportOverwrite.removeActionListener(this.checkBoxListener);
        this.secondaryExportOverwrite.removeActionListener(this.checkBoxListener);
        this.okButton.removeActionListener(this.buttonListener);
        this.cancelButton.removeActionListener(this.buttonListener);
        super.dispose();
    }

    public File getExportBinaryTargetFile(ESide eSide) {
        String string = FileUtils.ensureTrailingSlash(this.destinationDir.getPath());
        string = string + (eSide == ESide.PRIMARY ? this.primaryExportFileName.getText() : this.secondaryExportFileName.getText());
        string = BinDiffFileUtils.forceFilenameEndsWithExtension(string, "BinExport");
        return new File(string);
    }

    public String getFunctionDiffName() {
        return BinDiffFileUtils.forceFilenameEndsNotWithExtension(this.getMatchesDatabaseTargetFile().getName(), "BinDiff");
    }

    public File getMatchesDatabaseTargetFile() {
        String string = FileUtils.ensureTrailingSlash(this.destinationDir.getPath());
        string = string + this.diffDatabaseFileName.getText();
        string = BinDiffFileUtils.forceFilenameEndsWithExtension(string, "BinDiff");
        return new File(string);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isOverrideExportBinary(ESide eSide) {
        if (!this.okPressed) {
            return false;
        }
        if (eSide == ESide.PRIMARY) {
            return this.primaryExportOverwrite.isSelected();
        }
        return this.secondaryExportOverwrite.isSelected();
    }

    @Override
    public void setVisible(boolean bl2) {
        this.loadWorkspace();
        if (!this.workspace.isLoaded()) {
            this.dispose();
            return;
        }
        if (!this.createSingleViewsDirectory()) {
            String string = "Save function diff view failed. Couldn't create 'Function Diffs' directory'.";
            logger.at(Level.SEVERE).log("Save function diff view failed. Couldn't create 'Function Diffs' directory'.");
            MessageBox.showError(this.window, "Save function diff view failed. Couldn't create 'Function Diffs' directory'.");
            this.dispose();
            return;
        }
        if (!this.createDestinationDirectory()) {
            String string = "Save function diff view failed. Couldn't create destination directory.";
            logger.at(Level.SEVERE).log("Save function diff view failed. Couldn't create destination directory.");
            MessageBox.showError(this.window, "Save function diff view failed. Couldn't create destination directory.");
            this.dispose();
            return;
        }
        try {
            this.setDefaultNames();
        }
        catch (IOException iOException) {
            String string = "Save function diff view failed. Couldn't calculate source BinExport MD5.";
            ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Save function diff view failed. Couldn't calculate source BinExport MD5.");
            MessageBox.showError(this.window, "Save function diff view failed. Couldn't calculate source BinExport MD5.");
            return;
        }
        if (bl2) {
            this.okPressed = false;
        }
        super.setVisible(bl2);
    }

    private class InternalDocumentListener
    implements DocumentListener {
        private InternalDocumentListener() {
        }

        private void update() {
            try {
                SaveFunctionDiffViewDialog.this.updateFileOverwriteIndicator();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }
    }

    private class InternalCheckboxListener
    implements ActionListener {
        private InternalCheckboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SaveFunctionDiffViewDialog.this.primaryExportOverwrite && SaveFunctionDiffViewDialog.this.primaryExportOverwrite.isSelected() || actionEvent.getSource() == SaveFunctionDiffViewDialog.this.secondaryExportOverwrite && SaveFunctionDiffViewDialog.this.secondaryExportOverwrite.isSelected()) {
                MessageBox.showWarning(SaveFunctionDiffViewDialog.this, String.format("The file '%s' already exists with different contents!\nIf you choose override make sure that the new and the existing disassembly are\nstructurally identical, e.g. only comments have been added or modified. Otherwise,\nexisting older saved views may not be loadable anymore!", SaveFunctionDiffViewDialog.this.getExportBinaryTargetFile(actionEvent.getSource() == SaveFunctionDiffViewDialog.this.primaryExportOverwrite ? ESide.PRIMARY : ESide.SECONDARY).getName()));
            }
        }
    }

    private class InternalButtonListener
    implements ActionListener {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SaveFunctionDiffViewDialog.this.okButton) {
                try {
                    if (!SaveFunctionDiffViewDialog.this.validateInput()) {
                        return;
                    }
                    SaveFunctionDiffViewDialog.this.okPressed = true;
                }
                catch (IOException iOException) {
                    String string = "Save function diff view failed. Couldn't calculate source BinExport MD5.";
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(iOException)).log("Save function diff view failed. Couldn't calculate source BinExport MD5.");
                    MessageBox.showError(SaveFunctionDiffViewDialog.this.getParent(), "Save function diff view failed. Couldn't calculate source BinExport MD5.");
                    return;
                }
            }
            SaveFunctionDiffViewDialog.this.dispose();
        }
    }
}

