/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs;

import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CFilenameFormatter;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.io.DirectoryChooser;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;

public class NewWorkspaceDialog
extends BaseDialog {
    private static final int LABEL_WIDTH = 100;
    private static final int ROW_HEIGHT = 25;
    private static final int DIALOG_WIDTH = 445;
    private static final int DIALOG_HEIGHT = 190;
    private final JFormattedTextField workspaceName;
    private final FileChooserPanel workspaceDirectoryPanel;
    private final JCheckBox createDirectory = new JCheckBox("Create directory for workspace");
    private final JCheckBox defaultWorkspace = new JCheckBox("Use this as default workspace");
    private final JButton ok = new JButton("Ok");
    private final JButton cancel = new JButton("Cancel");
    private boolean okPressed;

    public NewWorkspaceDialog(Window window, String string) {
        super(window, string, 445, 190);
        CFilenameFormatter cFilenameFormatter = new CFilenameFormatter(new File(SystemHelpers.getApplicationDataDirectory()));
        this.workspaceName = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new DefaultFormatterFactory(cFilenameFormatter)));
        this.workspaceName.setText("BinDiff Workspace");
        String string2 = BinDiffConfig.getInstance().getMainSettings().getWorkspaceDirectory();
        if ("".equals(string2) || string2 == null) {
            string2 = SystemHelpers.getUserDirectory();
        }
        InternalActionListener internalActionListener = new InternalActionListener();
        this.workspaceDirectoryPanel = new FileChooserPanel(string2, internalActionListener, "...", 0, 25, 0);
        this.createDirectory.setSelected(true);
        this.ok.addActionListener(internalActionListener);
        this.cancel.addActionListener(internalActionListener);
        this.init();
        this.pack();
        GuiHelper.centerChildToParent(window, this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateValues() {
        String string = this.getWorkspaceName();
        if ("".equals(string) || string == null) {
            CMessageBox.showInformation(this, "A workspace need a name.");
            return false;
        }
        File file = new File(this.getWorkspacePath());
        if (file.exists()) {
            if (!file.isDirectory()) {
                CMessageBox.showInformation(this, "The specified workspace is not a directory.");
                return false;
            }
            if (file.list().length != 0) {
                CMessageBox.showInformation(this, "The specified workspace directory is not empty.");
                return false;
            }
        } else {
            boolean bl2 = false;
            try {
                bl2 = file.createNewFile();
            }
            catch (IOException iOException) {
                CMessageBox.showError(this, String.format("Could create workspace directory. '%s'", file.getAbsolutePath()));
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (bl2) {
                    file.delete();
                }
            }
            return bl2;
        }
        return true;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 5, 5));
        jPanel2.setBorder(new TitledBorder(""));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Name:", 100, this.workspaceName, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Location:", 100, this.workspaceDirectoryPanel, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("", 96, this.createDirectory, 25));
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel4.add(this.ok);
        jPanel4.add(this.cancel);
        jPanel3.add((Component)this.defaultWorkspace, "West");
        jPanel3.add((Component)jPanel4, "East");
        jPanel.add((Component)jPanel3, "South");
        this.add((Component)jPanel, "Center");
    }

    public String getWorkspaceName() {
        return this.workspaceName.getText();
    }

    public String getWorkspacePath() {
        if (this.createDirectory.isSelected()) {
            String string = this.workspaceDirectoryPanel.getText();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            return string + this.workspaceName.getText();
        }
        return this.workspaceDirectoryPanel.getText();
    }

    public boolean isDefaultWorkspace() {
        return this.defaultWorkspace.isSelected();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NewWorkspaceDialog.this.workspaceDirectoryPanel.getButton()) {
                DirectoryChooser directoryChooser = new DirectoryChooser("Select workspace location");
                directoryChooser.setSelectedFile(new File(NewWorkspaceDialog.this.workspaceDirectoryPanel.getText()));
                if (directoryChooser.showOpenDialog(NewWorkspaceDialog.this) == 0) {
                    File file = directoryChooser.getSelectedFile();
                    if (file.exists()) {
                        NewWorkspaceDialog.this.workspaceDirectoryPanel.setText(directoryChooser.getSelectedFile().getAbsolutePath());
                    } else {
                        CMessageBox.showError(directoryChooser, "Workspace directory does not exist. Please choose a valid one.");
                    }
                }
                return;
            }
            if (actionEvent.getSource() == NewWorkspaceDialog.this.ok) {
                if (!NewWorkspaceDialog.this.validateValues()) {
                    return;
                }
                NewWorkspaceDialog.this.okPressed = true;
            }
            NewWorkspaceDialog.this.dispose();
        }
    }
}

