/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.project.diff.DiffDirectories;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CFileChooser;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class NewDiffDialog
extends BaseDialog {
    private static final int IDB_FILE_FILTER_INDEX = 0;
    private static final int TEXTFIELD_WITH = 500;
    private static final int LABEL_WITH = 180;
    private static final int ROW_HEIGHT = 25;
    private final File workspaceDir;
    private final InternalPrimaryFileChooserListener primaryFileListener = new InternalPrimaryFileChooserListener();
    private final InternalSecondaryFileChooserListener secondaryFileListener = new InternalSecondaryFileChooserListener();
    private final InternalButtonListener buttonListener = new InternalButtonListener();
    private final JButton diffButton = new JButton(this.buttonListener);
    private final JButton cancelButton = new JButton(this.buttonListener);
    private final FileChooserPanel primaryChooser = new FileChooserPanel("", this.primaryFileListener, "...", 500, 25, 0);
    private final FileChooserPanel secondaryChooser = new FileChooserPanel("", this.secondaryFileListener, "...", 500, 25, 0);
    private final JTextField destinationDirName = TextComponentUtils.addDefaultEditorActions(new JTextField());
    private boolean diffPressed = false;
    private File lastSelectedFile = null;

    public NewDiffDialog(Window window, File file) {
        super(window, "New Diff");
        this.workspaceDir = Preconditions.checkNotNull(file);
        Preconditions.checkArgument(file.exists(), "Workspace directory doesn't exist.");
        this.init();
        this.pack();
        GuiHelper.centerChildToParent(window, this, true);
        this.setVisible(true);
    }

    private static File chooseFile(Component component, String string, File file, int n2) {
        CFileChooser cFileChooser = new CFileChooser(new CFileChooser.FileExtension(String.format("IDA Pro Database/BinExport Binary (*.%s;*.%s;*.%s)", "idb", "i64", "BinExport"), "idb", "i64", "BinExport"));
        cFileChooser.setCurrentDirectory(file);
        cFileChooser.setFileFilter(n2);
        cFileChooser.setApproveButtonText("Ok");
        cFileChooser.setDialogTitle(string);
        if (cFileChooser.showOpenDialog(component) == 0) {
            return cFileChooser.getSelectedFile();
        }
        return null;
    }

    private Component createButtonPanel() {
        this.diffButton.setText("Diff");
        this.cancelButton.setText("Cancel");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 0, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.add(this.diffButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private JPanel createDestinationFolderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Diff Destination"));
        this.destinationDirName.setPreferredSize(new Dimension(this.destinationDirName.getPreferredSize().width, 25));
        jPanel2.add((Component)this.destinationDirName, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel createFilesChooserPane() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 5, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 5, 5));
        jPanel2.setBorder(new TitledBorder("Primary Source"));
        jPanel3.setBorder(new TitledBorder("Secondary Source"));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Primary file:", 180, this.primaryChooser, 25));
        jPanel3.add(GuiUtils.createHorizontalNamedComponentPanel("Secondary file:", 180, this.secondaryChooser, 25));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private boolean isDiffExisting(File file) {
        for (String string : file.list()) {
            if (!string.toLowerCase().endsWith("BinDiff".toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void updateDestinationFolder() {
        String string = DiffDirectories.getDiffDestinationDirectoryName(this.primaryChooser.getText(), this.secondaryChooser.getText());
        this.destinationDirName.setText(string);
    }

    private boolean validateDiffSources() {
        File file = this.getIdb(ESide.PRIMARY);
        File file2 = this.getBinExportBinary(ESide.PRIMARY);
        if (file == null && file2 == null) {
            CMessageBox.showInformation(this, "Primary source files not set or do not exist.");
            return false;
        }
        File file3 = this.getIdb(ESide.SECONDARY);
        File file4 = this.getBinExportBinary(ESide.SECONDARY);
        if (file3 == null && file4 == null) {
            CMessageBox.showInformation(this, "Secondary source files not set or do not exist.");
            return false;
        }
        File file5 = this.getDestinationDirectory();
        if (file5 == null) {
            CMessageBox.showInformation(this, "Destination folder is not set.");
            return false;
        }
        if (file5.exists() && this.isDiffExisting(file5)) {
            CMessageBox.showInformation(this, "Diff file already exists in the workspace.");
            return false;
        }
        try {
            if (!file5.exists() && !file5.mkdirs()) {
                CMessageBox.showInformation(this, "Could not create destination folder.");
                return false;
            }
        }
        catch (SecurityException securityException) {
            CMessageBox.showInformation(this, "Could not create destination folder.");
            return false;
        }
        return true;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.createFilesChooserPane(), "North");
        jPanel.add((Component)this.createDestinationFolderPanel(), "Center");
        jPanel.add(this.createButtonPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    public File getBinExportBinary(ESide eSide) {
        File file = new File(eSide == ESide.PRIMARY ? this.primaryChooser.getText() : this.secondaryChooser.getText());
        return file.exists() ? file : null;
    }

    public File getDestinationDirectory() {
        if (this.destinationDirName.getText().equals("")) {
            return null;
        }
        return new File(String.join((CharSequence)"", this.workspaceDir.getPath(), File.separator, this.destinationDirName.getText()));
    }

    public boolean getDiffButtonPressed() {
        return this.diffPressed;
    }

    public File getIdb(ESide eSide) {
        File file;
        String string;
        String string2 = string = eSide == ESide.PRIMARY ? this.primaryChooser.getText() : this.secondaryChooser.getText();
        if ((string.endsWith(".idb") || string.endsWith(".i64")) && (file = new File(string)).exists()) {
            return file;
        }
        return null;
    }

    private class InternalSecondaryFileChooserListener
    implements ActionListener {
        private InternalSecondaryFileChooserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
            File file = NewDiffDialog.chooseFile(NewDiffDialog.this, "Choose Secondary File", NewDiffDialog.this.lastSelectedFile == null ? new File(binDiffConfig.getMainSettings().getNewDiffLastSecondaryDir()) : NewDiffDialog.this.lastSelectedFile, 0);
            if (file != null) {
                NewDiffDialog.this.secondaryChooser.setText(file.getPath());
                NewDiffDialog.this.lastSelectedFile = file.getParentFile();
                binDiffConfig.getMainSettings().setNewDiffLastSecondaryDir(NewDiffDialog.this.lastSelectedFile.getPath());
            }
            NewDiffDialog.this.updateDestinationFolder();
        }
    }

    private class InternalPrimaryFileChooserListener
    implements ActionListener {
        private InternalPrimaryFileChooserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
            File file = NewDiffDialog.chooseFile(NewDiffDialog.this, "Choose Primary File", NewDiffDialog.this.lastSelectedFile == null ? new File(binDiffConfig.getMainSettings().getNewDiffLastPrimaryDir()) : NewDiffDialog.this.lastSelectedFile, 0);
            if (file != null) {
                NewDiffDialog.this.primaryChooser.setText(file.getPath());
                NewDiffDialog.this.lastSelectedFile = file.getParentFile();
                binDiffConfig.getMainSettings().setNewDiffLastPrimaryDir(NewDiffDialog.this.lastSelectedFile.getPath());
            }
            NewDiffDialog.this.updateDestinationFolder();
        }
    }

    private class InternalButtonListener
    extends AbstractAction {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(NewDiffDialog.this.diffButton)) {
                if (!NewDiffDialog.this.validateDiffSources()) {
                    return;
                }
                NewDiffDialog.this.diffPressed = true;
            }
            NewDiffDialog.this.dispose();
        }
    }
}

