/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSearcher;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class GraphSearchOptionsDialog
extends BaseDialog {
    private final InternalButtonListener buttonListener = new InternalButtonListener();
    private final JCheckBox regEx = new JCheckBox("Regular Expression");
    private final JCheckBox caseSensitive = new JCheckBox("Case Sensitive");
    private final JCheckBox visibleOnly = new JCheckBox("Visible Only");
    private final JCheckBox selectedOnly = new JCheckBox("Selected Only");
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Cancel");
    private final JButton setDefaultsButton = new JButton("Set Defaults");
    private final GraphSearcher searcher;
    private boolean originalRegEx;
    private boolean originalCaseSensitive;
    private boolean originalVisibleOnly;
    private boolean originalSelectedOnly;

    public GraphSearchOptionsDialog(Window window, BinDiffGraph<?, ?> binDiffGraph) {
        super(window, "Search Options");
        Preconditions.checkNotNull(binDiffGraph);
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.searcher = binDiffGraph.getGraphSearcher();
        this.regEx.setSelected(this.searcher.isRegEx());
        this.caseSensitive.setSelected(this.searcher.isCaseSensitive());
        this.visibleOnly.setSelected(this.searcher.isVisibleOnly());
        this.selectedOnly.setSelected(this.searcher.isSelectedOnly());
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
        this.setDefaultsButton.addActionListener(this.buttonListener);
        this.init();
        this.pack();
        this.setMinimumSize(this.getSize());
        GuiHelper.centerChildToParent(window, this, true);
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.setDefaultsButton, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JPanel createOptionsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setBorder(new TitledBorder(""));
        jPanel2.add(this.regEx);
        jPanel2.add(this.caseSensitive);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.setBorder(new TitledBorder(""));
        jPanel3.add(this.visibleOnly);
        jPanel3.add(this.selectedOnly);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(""));
        jPanel.add((Component)this.createOptionsPanel(), "North");
        jPanel.add((Component)this.createButtonsPanel(), "South");
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setVisible(boolean bl2) {
        if (bl2) {
            this.originalRegEx = this.regEx.isSelected();
            this.originalCaseSensitive = this.caseSensitive.isSelected();
            this.originalVisibleOnly = this.visibleOnly.isSelected();
            this.originalSelectedOnly = this.selectedOnly.isSelected();
        }
        super.setVisible(bl2);
    }

    private class InternalButtonListener
    implements ActionListener {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(GraphSearchOptionsDialog.this.setDefaultsButton)) {
                GraphSearchOptionsDialog.this.searcher.setRegEx(false);
                GraphSearchOptionsDialog.this.searcher.setCaseSensitive(false);
                GraphSearchOptionsDialog.this.searcher.setOnlySelected(false);
                GraphSearchOptionsDialog.this.searcher.setOnlyVisible(false);
                GraphSearchOptionsDialog.this.regEx.setSelected(false);
                GraphSearchOptionsDialog.this.caseSensitive.setSelected(false);
                GraphSearchOptionsDialog.this.selectedOnly.setSelected(false);
                GraphSearchOptionsDialog.this.visibleOnly.setSelected(false);
                return;
            }
            if (actionEvent.getSource().equals(GraphSearchOptionsDialog.this.okButton)) {
                GraphSearchOptionsDialog.this.searcher.setRegEx(GraphSearchOptionsDialog.this.regEx.isSelected());
                GraphSearchOptionsDialog.this.searcher.setCaseSensitive(GraphSearchOptionsDialog.this.caseSensitive.isSelected());
                GraphSearchOptionsDialog.this.searcher.setOnlySelected(GraphSearchOptionsDialog.this.selectedOnly.isSelected());
                GraphSearchOptionsDialog.this.searcher.setOnlyVisible(GraphSearchOptionsDialog.this.visibleOnly.isSelected());
            }
            if (actionEvent.getSource().equals(GraphSearchOptionsDialog.this.cancelButton)) {
                GraphSearchOptionsDialog.this.regEx.setSelected(GraphSearchOptionsDialog.this.originalRegEx);
                GraphSearchOptionsDialog.this.caseSensitive.setSelected(GraphSearchOptionsDialog.this.originalCaseSensitive);
                GraphSearchOptionsDialog.this.visibleOnly.setSelected(GraphSearchOptionsDialog.this.originalVisibleOnly);
                GraphSearchOptionsDialog.this.selectedOnly.setSelected(GraphSearchOptionsDialog.this.originalSelectedOnly);
            }
            GraphSearchOptionsDialog.this.setVisible(false);
        }
    }
}

