/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs;

import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.io.DirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ExportViewDialog
extends BaseDialog {
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 263;
    private static final int LABEL_WIDTH = 200;
    private static final int ROW_HEIGHT = 25;
    private final Window window;
    private final String description;
    private final FileChooserPanel destinationChooserPanel;
    private final JTextField primaryImageName;
    private final JTextField secondaryImageName;
    private final JTextField combinedImageName;
    private final JComboBox<String> imageFormat;
    private final JComboBox<String> captureRegion;
    private final JButton okButton = new JButton("Ok");
    private final JButton cancelButton = new JButton("Cancel");
    private final ActionListener buttonListener = new InternalButtonListener();
    private boolean okPressed = false;

    public ExportViewDialog(Window window, String string, String string2, File file, String string3) {
        super(window, string);
        this.window = window;
        this.description = string2;
        this.okButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
        InternalDestinationDirectoryListener internalDestinationDirectoryListener = new InternalDestinationDirectoryListener();
        this.destinationChooserPanel = new FileChooserPanel(file.getPath(), internalDestinationDirectoryListener, "...", 0, 25, 0);
        this.primaryImageName = TextComponentUtils.addDefaultEditorActions(new JTextField("primary_" + string3));
        this.secondaryImageName = TextComponentUtils.addDefaultEditorActions(new JTextField("secondary_" + string3));
        this.combinedImageName = TextComponentUtils.addDefaultEditorActions(new JTextField("combined_" + string3));
        this.imageFormat = new JComboBox();
        this.imageFormat.addItem("PNG");
        this.imageFormat.addItem("JPEG");
        this.imageFormat.addItem("GIF");
        this.imageFormat.addItem("SVG");
        this.captureRegion = new JComboBox();
        this.captureRegion.addItem("Graph");
        this.captureRegion.addItem("View");
        this.init();
        this.setSize(600, 263);
        this.setMinimumSize(new Dimension(600, 263));
        GuiHelper.centerChildToParent(window, this, true);
    }

    private boolean confirmOverwrites() {
        File file;
        File file2;
        String string = "";
        File file3 = this.getPrimaryImageFile();
        if (file3.exists()) {
            string = string + file3.getPath() + "\n";
        }
        if ((file2 = this.getSecondaryImageFile()).exists()) {
            string = string + file2.getPath() + "\n";
        }
        if ((file = this.getCombinedImageFile()).exists()) {
            string = string + file.getPath() + "\n";
        }
        if (!string.equals("")) {
            return CMessageBox.showYesNoQuestion(this, String.format("%s\n These files already exist. Overwrite?", string)) == 0;
        }
        return true;
    }

    private File getImageFile(String string) {
        String string2 = this.destinationChooserPanel.getText().replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        String[] stringArray = new String[]{".png", ".jpeg", ".gif", ".svg"};
        string2 = string2 + string + stringArray[this.imageFormat.getSelectedIndex()];
        return new File(string2);
    }

    private String selectDirectory(Window window) {
        DirectoryChooser directoryChooser = new DirectoryChooser("Choose Destination Directory");
        directoryChooser.setCurrentDirectory(new File(this.destinationChooserPanel.getText()));
        if (directoryChooser.showOpenDialog(window) == 0) {
            return directoryChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private boolean validatePaths() {
        try {
            File file;
            File file2;
            File file3 = this.getPrimaryImageFile();
            if (file3.createNewFile()) {
                file3.delete();
            }
            if ((file2 = this.getSecondaryImageFile()).createNewFile()) {
                file2.delete();
            }
            if ((file = this.getCombinedImageFile()).createNewFile()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(6, 1, 3, 3));
        jPanel2.setBorder(new TitledBorder(this.description));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Destination directory:", 200, this.destinationChooserPanel, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Primary image name:", 200, this.primaryImageName, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Secondary image name:", 200, this.secondaryImageName, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Combined image name:", 200, this.combinedImageName, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Image file format:", 200, this.imageFormat, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Clip Area:", 200, this.captureRegion, 25));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(8, 5, 5, 5));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel4.add(this.okButton);
        jPanel4.add(this.cancelButton);
        jPanel3.add((Component)jPanel4, "East");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        this.add((Component)jPanel, "Center");
        this.pack();
    }

    @Override
    public void dispose() {
        this.okButton.removeActionListener(this.buttonListener);
        this.cancelButton.removeActionListener(this.buttonListener);
        super.dispose();
    }

    public File getCombinedImageFile() {
        return this.getImageFile(this.combinedImageName.getText());
    }

    public File getPrimaryImageFile() {
        return this.getImageFile(this.primaryImageName.getText());
    }

    public File getSecondaryImageFile() {
        return this.getImageFile(this.secondaryImageName.getText());
    }

    public boolean isCaptureAll() {
        return this.captureRegion.getSelectedIndex() == 0;
    }

    public boolean isCapturePart() {
        return this.captureRegion.getSelectedIndex() == 1;
    }

    public boolean isGIF() {
        return this.imageFormat.getSelectedIndex() == 2;
    }

    public boolean isJPEG() {
        return this.imageFormat.getSelectedIndex() == 1;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isPNG() {
        return this.imageFormat.getSelectedIndex() == 0;
    }

    public boolean isSVG() {
        return this.imageFormat.getSelectedIndex() == 3;
    }

    private class InternalDestinationDirectoryListener
    implements ActionListener {
        private InternalDestinationDirectoryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ExportViewDialog.this.selectDirectory(ExportViewDialog.this.window);
            if (string != null) {
                ExportViewDialog.this.destinationChooserPanel.setText(string);
            }
        }
    }

    private class InternalButtonListener
    implements ActionListener {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(ExportViewDialog.this.okButton)) {
                if (!ExportViewDialog.this.validatePaths()) {
                    CMessageBox.showInformation(ExportViewDialog.this.window, "Illegal image file names. Please enter valid names.");
                    return;
                }
                if (!ExportViewDialog.this.confirmOverwrites()) {
                    return;
                }
                ExportViewDialog.this.okPressed = true;
            }
            ExportViewDialog.this.dispose();
        }
    }
}

