/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.dialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.config.BinDiffConfig;
import com.google.security.zynamics.bindiff.database.MatchesDatabase;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.dialogs.BaseDialog;
import com.google.security.zynamics.bindiff.project.Workspace;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CFileChooser;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.FileChooser.FileChooserPanel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class AddDiffDialog
extends BaseDialog {
    private static final int TEXTFIELD_WIDTH = 500;
    private static final int LABEL_WIDTH = 180;
    private static final int ROW_HEIGHT = 25;
    private final Workspace workspace;
    private final InternalDiffChooserListener diffChooserListener = new InternalDiffChooserListener();
    private final InternalButtonListener buttonListener = new InternalButtonListener();
    private final JButton addButton = new JButton(this.buttonListener);
    private final JButton cancelButton = new JButton(this.buttonListener);
    private final FileChooserPanel diffChooser = new FileChooserPanel("", this.diffChooserListener, "...", 500, 25, 0);
    private final JTextField primaryExportBinary = TextComponentUtils.addDefaultEditorActions(new JTextField());
    private final JTextField secondaryExportBinary = TextComponentUtils.addDefaultEditorActions(new JTextField());
    private final JTextField destinationDirName = TextComponentUtils.addDefaultEditorActions(new JTextField());
    private boolean diffPressed = false;

    public AddDiffDialog(Window window, Workspace workspace) {
        super(window, "Add Existing Diff");
        this.workspace = Preconditions.checkNotNull(workspace);
        this.init();
        this.pack();
        GuiHelper.centerChildToParent(window, this, true);
        this.setVisible(true);
    }

    private static File chooseFile(Component component, String string, File file) {
        CFileChooser cFileChooser = new CFileChooser("BinDiff", "BinDiff Matches Database");
        cFileChooser.setCurrentDirectory(file);
        cFileChooser.setApproveButtonText("Ok");
        cFileChooser.setDialogTitle(string);
        if (cFileChooser.showOpenDialog(component) == 0) {
            return cFileChooser.getSelectedFile();
        }
        return null;
    }

    private JPanel createButtonPanel() {
        this.addButton.setText("Add");
        this.cancelButton.setText("Cancel");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 0, 5, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        jPanel2.add(this.addButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private JPanel createDestinationFolderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Diff Destination"));
        this.destinationDirName.setPreferredSize(new Dimension(this.destinationDirName.getPreferredSize().width, 25));
        jPanel2.add((Component)this.destinationDirName, "North");
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel createExportSourcesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Export Binaries"));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 5));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Primary Call Graph:", 180, this.primaryExportBinary, 25));
        jPanel2.add(GuiUtils.createHorizontalNamedComponentPanel("Secondary Call Graph:", 180, this.secondaryExportBinary, 25));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private JPanel createFileChooserPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new TitledBorder("Diff Matches Database:"));
        jPanel2.add((Component)GuiUtils.createHorizontalNamedComponentPanel("Choose Diff:", 180, this.diffChooser, 25), "North");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.createExportSourcesPanel(), "Center");
        return jPanel;
    }

    private Pair<String, String> getIDBName(File file) {
        try (MatchesDatabase matchesDatabase = new MatchesDatabase(file);){
            String[] stringArray = matchesDatabase.getIDBNames();
            Pair<String, String> pair = new Pair<String, String>(stringArray[0], stringArray[1]);
            return pair;
        }
    }

    private void updatedExportedSources() {
        Pair<String, String> pair;
        File file = new File(this.diffChooser.getText());
        try {
            pair = this.getIDBName(file);
        }
        catch (SQLException sQLException) {
            CMessageBox.showInformation(this, "Couldn't load necessary diff information: " + sQLException.getMessage());
            return;
        }
        String string = pair.first();
        String string2 = pair.second();
        if (string == null || "".equals(string) || string2 == null || "".equals(string2)) {
            CMessageBox.showInformation(this, "Couldn't load necessary diff information.");
            return;
        }
        String string3 = String.join((CharSequence)"", file.getParent(), File.separator, string, ".", "BinExport");
        String string4 = String.join((CharSequence)"", file.getParent(), File.separator, string2, ".", "BinExport");
        if (!new File(string3).exists()) {
            this.primaryExportBinary.setBackground(Colors.TABLE_CELL_PRIMARY_DEFAULT_BACKGROUND);
        } else {
            this.primaryExportBinary.setBackground(Colors.GRAY240);
        }
        if (!new File(string4).exists()) {
            this.secondaryExportBinary.setBackground(Colors.TABLE_CELL_PRIMARY_DEFAULT_BACKGROUND);
        } else {
            this.secondaryExportBinary.setBackground(Colors.GRAY240);
        }
        this.primaryExportBinary.setText(string3);
        this.secondaryExportBinary.setText(string4);
        String string5 = String.format("%s vs %s", string, string2);
        this.destinationDirName.setText(string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateDiffSources() {
        File file = this.getMatchesBinary();
        File file2 = this.getBinExportBinary(ESide.PRIMARY);
        File file3 = this.getBinExportBinary(ESide.SECONDARY);
        File file4 = this.getDestinationDirectory();
        String string = "";
        if (file == null) {
            string = "Can't add diff to workspace. Can't find matches binary.";
        } else if (file2 == null) {
            string = "Can't add diff to workspace. Can't find primary BinExport binary.";
        } else if (file3 == null) {
            string = "Can't add diff to workspace. Can't find secondary BinExport binary.";
        } else if (file4 == null) {
            string = "Can't add diff to workspace. Destination folder is not defined.";
        } else if (this.workspace.containsDiff(file.getPath())) {
            string = "Diff is already added to the workspace.";
        } else if (file4.exists() && file4.list().length != 0) {
            if (!file.getParent().equals(file4.getPath())) {
                string = "Can't add diff to workspace. Destination folder already exists in workspace.";
            } else if (this.workspace.containsDiff(file.getPath())) {
                string = "Can't add diff to workspace. Diff is already part of the current workspace.";
            }
        } else {
            try {
                if (!file4.mkdir()) {
                    string = "Can't add diff to workspace. Destination folder cannot be created.";
                }
            }
            catch (Exception exception) {
                string = "Can't add diff to workspace. Destination folder cannot be created.";
            }
            finally {
                file4.delete();
            }
        }
        if (!string.equals("")) {
            CMessageBox.showInformation(this, string);
        }
        return string.equals("");
    }

    private void init() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.createFileChooserPane(), "North");
        jPanel.add((Component)this.createDestinationFolderPanel(), "Center");
        jPanel.add((Component)this.createButtonPanel(), "South");
        this.primaryExportBinary.setEditable(false);
        this.secondaryExportBinary.setEditable(false);
        this.primaryExportBinary.setBorder(new LineBorder(Color.GRAY));
        this.secondaryExportBinary.setBorder(new LineBorder(Color.GRAY));
        this.add((Component)jPanel, "Center");
    }

    public boolean getAddButtonPressed() {
        return this.diffPressed;
    }

    public File getBinExportBinary(ESide eSide) {
        File file;
        String string;
        String string2 = string = eSide == ESide.PRIMARY ? this.primaryExportBinary.getText() : this.secondaryExportBinary.getText();
        if (string.endsWith(".BinExport") && (file = new File(string)).exists()) {
            return file;
        }
        return null;
    }

    public File getDestinationDirectory() {
        if (this.destinationDirName.getText().equals("")) {
            return null;
        }
        return new File(String.join((CharSequence)"", this.workspace.getWorkspaceDirPath(), File.separator, this.destinationDirName.getText()));
    }

    public File getMatchesBinary() {
        File file = new File(this.diffChooser.getText());
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private class InternalDiffChooserListener
    implements ActionListener {
        private InternalDiffChooserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BinDiffConfig binDiffConfig = BinDiffConfig.getInstance();
            File file = AddDiffDialog.chooseFile(AddDiffDialog.this, "Choose Diff", new File(binDiffConfig.getMainSettings().getAddExistingDiffLastDir()));
            if (file != null && file.exists()) {
                AddDiffDialog.this.diffChooser.setText(file.getPath());
                binDiffConfig.getMainSettings().setAddExistingDiffLastDir(file.getParent());
                AddDiffDialog.this.updatedExportedSources();
            }
        }
    }

    private class InternalButtonListener
    extends AbstractAction {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(AddDiffDialog.this.addButton)) {
                if (!AddDiffDialog.this.validateDiffSources()) {
                    return;
                }
                AddDiffDialog.this.diffPressed = true;
            }
            AddDiffDialog.this.dispose();
        }
    }
}

