/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.components.viewsearchfield;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.components.viewsearchfield.IViewSearchFieldListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.treenodepanels.tables.AbstractTable;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.comboboxes.memorybox.JMemoryBox;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;

public class TableTextSearchComboBox
extends JMemoryBox {
    private static final Color BACKGROUND_COLOR_FAIL = Colors.GRAY224;
    private static final Color BACKGROUND_COLOR_SUCCESS = Color.WHITE;
    private static final int SEARCH_STRING_HISTORY_MAX = 30;
    private final ListenerProvider<IViewSearchFieldListener> listeners = new ListenerProvider();
    private final AbstractTable table;
    private final List<Pair<Integer, ESide>> affectedColumnIndices;
    private boolean isRegEx;
    private boolean isCaseSensitive;
    private boolean primarySideSearch;
    private boolean secondarySideSearch;
    private boolean temporaryTableUse;

    public TableTextSearchComboBox(AbstractTable abstractTable, List<Pair<Integer, ESide>> list) {
        super(30);
        this.table = Preconditions.checkNotNull(abstractTable);
        this.affectedColumnIndices = Preconditions.checkNotNull(list);
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        TextComponentUtils.addDefaultEditorActions(jTextField);
        jTextField.addKeyListener(new InternalKeyListener());
    }

    private String getText() {
        return ((JTextField)this.getEditor().getEditorComponent()).getText();
    }

    private void search(boolean bl2) {
        List<Integer> list = this.search(this.getText());
        if (list.size() == 0) {
            this.getEditor().getEditorComponent().setBackground(BACKGROUND_COLOR_FAIL);
        } else {
            for (IViewSearchFieldListener iViewSearchFieldListener : this.listeners) {
                iViewSearchFieldListener.searched(list, bl2);
            }
            this.getEditor().getEditorComponent().setBackground(BACKGROUND_COLOR_SUCCESS);
        }
    }

    private List<Integer> search(String string) {
        if (!"".equals(string)) {
            this.add(string);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (!this.temporaryTableUse) {
            this.reset();
        }
        int n2 = this.table.getRowCount();
        boolean bl2 = this.primarySideSearch;
        boolean bl3 = this.secondarySideSearch;
        if (!bl2 && !bl3) {
            bl2 = true;
            bl3 = true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl4;
            StringBuilder stringBuilder = new StringBuilder();
            for (Pair<Integer, ESide> pair : this.affectedColumnIndices) {
                if (pair.second() == ESide.PRIMARY && bl2) {
                    stringBuilder.append(this.table.getValueAt(i2, pair.first()));
                    continue;
                }
                if (pair.second() != ESide.SECONDARY || !bl3) continue;
                stringBuilder.append(this.table.getValueAt(i2, (Integer)pair.first()));
            }
            if (this.isRegEx) {
                Pair<Integer, ESide> pair;
                Pattern pattern = this.isCaseSensitive ? Pattern.compile(string) : Pattern.compile(string, 2);
                pair = pattern.matcher(stringBuilder.toString());
                bl4 = ((Matcher)((Object)pair)).find(0);
            } else {
                bl4 = this.isCaseSensitive ? stringBuilder.toString().contains(string) : stringBuilder.toString().toLowerCase().contains(string.toLowerCase());
            }
            if (!bl4) continue;
            arrayList.add(i2);
        }
        return arrayList;
    }

    public void addListener(IViewSearchFieldListener iViewSearchFieldListener) {
        this.listeners.addListener(iViewSearchFieldListener);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isPrimarySideSearch() {
        return this.primarySideSearch;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public boolean isSecondarySideSearch() {
        return this.secondarySideSearch;
    }

    public boolean isTemporaryTableUse() {
        return this.temporaryTableUse;
    }

    public void removeListener(IViewSearchFieldListener iViewSearchFieldListener) {
        this.listeners.removeListener(iViewSearchFieldListener);
    }

    public void reset() {
        for (IViewSearchFieldListener iViewSearchFieldListener : this.listeners) {
            iViewSearchFieldListener.reset();
        }
    }

    public void setSearchOptions(boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.isRegEx = bl2;
        this.isCaseSensitive = bl3;
        this.primarySideSearch = bl4;
        this.secondarySideSearch = bl5;
        this.temporaryTableUse = bl6;
        this.search(this.getText());
    }

    public void updateResults() {
        if (!"".equals(this.getText())) {
            this.search(false);
        }
    }

    private class InternalKeyListener
    extends KeyAdapter {
        private InternalKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                if ("".equals(TableTextSearchComboBox.this.getText())) {
                    for (IViewSearchFieldListener iViewSearchFieldListener : TableTextSearchComboBox.this.listeners) {
                        iViewSearchFieldListener.reset();
                    }
                    TableTextSearchComboBox.this.getEditor().getEditorComponent().setBackground(BACKGROUND_COLOR_SUCCESS);
                } else {
                    TableTextSearchComboBox.this.search(keyEvent.getModifiersEx() == 128);
                }
            }
        }
    }
}

