/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.components.treesearchfield;

import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.components.treesearchfield.ITreeSearchFieldListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.comboboxes.memorybox.JMemoryBox;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class TreeSearchFieldCombo
extends JMemoryBox {
    private static final int SEARCH_STRING_HISTORY_MAX = 25;
    private final ListenerProvider<ITreeSearchFieldListener> listeners = new ListenerProvider();
    private final InternalKeyListener listener = new InternalKeyListener();
    private String lastSearchString = "";

    public TreeSearchFieldCombo() {
        super(25);
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        TextComponentUtils.addDefaultEditorActions(jTextField);
        jTextField.addKeyListener(this.listener);
    }

    private String getText() {
        return ((JTextField)this.getEditor().getEditorComponent()).getText();
    }

    public void addListener(ITreeSearchFieldListener iTreeSearchFieldListener) {
        this.listeners.addListener(iTreeSearchFieldListener);
    }

    public void clear() {
        this.setSelectedItem("");
        this.lastSearchString = "";
    }

    public void dispose() {
        this.getEditor().getEditorComponent().removeKeyListener(this.listener);
    }

    public void removeListener(ITreeSearchFieldListener iTreeSearchFieldListener) {
        this.listeners.removeListener(iTreeSearchFieldListener);
    }

    private class InternalKeyListener
    implements KeyListener {
        private InternalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n' && !TreeSearchFieldCombo.this.getText().equals(TreeSearchFieldCombo.this.lastSearchString)) {
                if (!TreeSearchFieldCombo.this.getText().equals("")) {
                    TreeSearchFieldCombo.this.add(TreeSearchFieldCombo.this.getText());
                }
                for (ITreeSearchFieldListener iTreeSearchFieldListener : TreeSearchFieldCombo.this.listeners) {
                    iTreeSearchFieldListener.searchChanged(TreeSearchFieldCombo.this.getText());
                }
                TreeSearchFieldCombo.this.lastSearchString = TreeSearchFieldCombo.this.getText();
            }
        }
    }
}

