/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.components.graphsearchfield;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.helpers.GraphZoomer;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.searchers.GraphAddressSearcher;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSeacherFunctions;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSearcher;
import com.google.security.zynamics.bindiff.gui.components.TextComponentUtils;
import com.google.security.zynamics.bindiff.gui.components.graphsearchfield.IGraphSearchFieldListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.bindiff.utils.ImageUtils;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.CHexFormatter;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.comboboxes.memorybox.JMemoryBox;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class GraphSearchField
extends JPanel {
    private static final int SEARCH_STRING_HISTORY_MAX = 50;
    private static final Icon ICON_CLEAR = ImageUtils.getImageIcon("data/buttonicons/clear.png");
    private static final Icon ICON_CLEAR_GRAY = ImageUtils.getImageIcon("data/buttonicons/clear-gray.png");
    private static final Icon ICON_NORMAL_SEARCH = ImageUtils.getImageIcon("data/buttonicons/normal-search.png");
    private static final Icon ICON_JUMP_TO_PRIMARY_ADDRESS = ImageUtils.getImageIcon("data/buttonicons/jump-primary-address.png");
    private static final Icon ICON_JUMP_TO_SECONDARY_ADDRESS = ImageUtils.getImageIcon("data/buttonicons/jump-secondary-address.png");
    private static final Icon ICON_NORMAL_SEARCH_FIELD = ImageUtils.getImageIcon("data/buttonicons/normal-searchfield.png");
    private static final Icon ICON_JUMP_TO_PRIMARY_ADDRESS_FIELD = ImageUtils.getImageIcon("data/buttonicons/jump-primary-addressfield.png");
    private static final Icon ICON_JUMP_TO_SECONDARY_ADDRESS_FIELD = ImageUtils.getImageIcon("data/buttonicons/jump-secondary-addressfield.png");
    private static final Color BACKGROUND_COLOR_FAIL = Colors.GRAY224;
    private static final Color BACKGROUND_COLOR_SUCCESS = Color.WHITE;
    private static final int ICON_SPACE = 38;
    private static final Insets BORDER_INSETS = new Insets(2, 38, 2, 0);
    private final ListenerProvider<IGraphSearchFieldListener> listeners = new ListenerProvider();
    private final MouseListener mouseListener;
    private final ViewTabPanelFunctions controller;
    private final GraphsContainer graphs;
    private final JMemoryBox searchCombo = new JMemoryBox(50);
    private final JMemoryBox priJumpCombo = new JMemoryBox(50);
    private final JMemoryBox secJumpCombo = new JMemoryBox(50);
    private final JTextField searchField = TextComponentUtils.addDefaultEditorActions(new JTextField());
    private final JFormattedTextField priHexField = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CHexFormatter(16)));
    private final JFormattedTextField secHexField = TextComponentUtils.addDefaultEditorActions(new JFormattedTextField(new CHexFormatter(16)));
    private final JButton clearSearchResultsButton;
    private final CPopupChooserAction popupChooserAction = new CPopupChooserAction();
    private Icon activeIcon = ICON_NORMAL_SEARCH_FIELD;

    public GraphSearchField(ViewTabPanelFunctions viewTabPanelFunctions, JButton jButton) {
        super(new BorderLayout());
        this.clearSearchResultsButton = jButton;
        this.clearSearchResultsButton.setIcon(ICON_CLEAR_GRAY);
        this.controller = Preconditions.checkNotNull(viewTabPanelFunctions);
        this.graphs = viewTabPanelFunctions.getGraphs();
        this.setEditors();
        CEditorBorder cEditorBorder = new CEditorBorder();
        this.searchField.setBorder(cEditorBorder);
        this.priHexField.setBorder(cEditorBorder);
        this.secHexField.setBorder(cEditorBorder);
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "search");
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "search");
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "search");
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(10, 192), "search");
        CSearchAction cSearchAction = new CSearchAction();
        this.searchField.getActionMap().put("search", cSearchAction);
        this.priHexField.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "zoomToAddress");
        this.priHexField.getActionMap().put("zoomToAddress", new CZoomToAddressAction());
        this.secHexField.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "zoomToAddress");
        this.secHexField.getActionMap().put("zoomToAddress", new CZoomToAddressAction());
        this.mouseListener = new InternalMouseListener();
        this.searchField.addMouseListener(this.mouseListener);
        this.priHexField.addMouseListener(this.mouseListener);
        this.secHexField.addMouseListener(this.mouseListener);
        this.add((Component)this.searchCombo, "Center");
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(GuiUtils.buildMenuItem("Search Node Contents", ICON_NORMAL_SEARCH, (AbstractAction)this.popupChooserAction));
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(GuiUtils.buildMenuItem("Jump to Primary Address", ICON_JUMP_TO_PRIMARY_ADDRESS, (AbstractAction)this.popupChooserAction));
        jPopupMenu.add(GuiUtils.buildMenuItem("Jump to Secondary Address", ICON_JUMP_TO_SECONDARY_ADDRESS, (AbstractAction)this.popupChooserAction));
        return jPopupMenu;
    }

    private void setEditors() {
        this.searchCombo.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return GraphSearchField.this.searchField;
            }
        });
        this.priJumpCombo.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return GraphSearchField.this.priHexField;
            }
        });
        this.secJumpCombo.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return GraphSearchField.this.secHexField;
            }
        });
    }

    private void updateSearchBox(Icon icon) {
        if (icon == ICON_NORMAL_SEARCH && this.activeIcon == ICON_NORMAL_SEARCH_FIELD) {
            this.searchField.getCaret().setVisible(true);
            this.searchField.grabFocus();
            this.searchCombo.updateUI();
            return;
        }
        if (icon == ICON_JUMP_TO_PRIMARY_ADDRESS && this.activeIcon == ICON_JUMP_TO_PRIMARY_ADDRESS_FIELD) {
            this.priHexField.getCaret().setVisible(true);
            this.priHexField.grabFocus();
            this.priJumpCombo.updateUI();
            return;
        }
        if (icon == ICON_JUMP_TO_SECONDARY_ADDRESS && this.activeIcon == ICON_JUMP_TO_SECONDARY_ADDRESS_FIELD) {
            this.secHexField.getCaret().setVisible(true);
            this.secHexField.grabFocus();
            this.secJumpCombo.updateUI();
            return;
        }
        if (this.activeIcon == ICON_NORMAL_SEARCH_FIELD) {
            this.remove(this.searchCombo);
        } else if (this.activeIcon == ICON_JUMP_TO_PRIMARY_ADDRESS_FIELD) {
            this.remove(this.priJumpCombo);
        } else if (this.activeIcon == ICON_JUMP_TO_SECONDARY_ADDRESS_FIELD) {
            this.remove(this.secJumpCombo);
        }
        if (icon == ICON_NORMAL_SEARCH) {
            this.activeIcon = ICON_NORMAL_SEARCH_FIELD;
        } else if (icon == ICON_JUMP_TO_PRIMARY_ADDRESS) {
            this.activeIcon = ICON_JUMP_TO_PRIMARY_ADDRESS_FIELD;
        } else if (icon == ICON_JUMP_TO_SECONDARY_ADDRESS) {
            this.activeIcon = ICON_JUMP_TO_SECONDARY_ADDRESS_FIELD;
        }
        if (this.activeIcon == ICON_NORMAL_SEARCH_FIELD) {
            this.add(this.searchCombo);
            this.searchField.getCaret().setVisible(true);
            this.searchField.grabFocus();
            this.searchCombo.updateUI();
        } else if (this.activeIcon == ICON_JUMP_TO_PRIMARY_ADDRESS_FIELD) {
            this.add(this.priJumpCombo);
            this.priHexField.getCaret().setVisible(true);
            this.priHexField.grabFocus();
            this.priJumpCombo.updateUI();
        } else if (this.activeIcon == ICON_JUMP_TO_SECONDARY_ADDRESS_FIELD) {
            this.add(this.secJumpCombo);
            this.secHexField.getCaret().setVisible(true);
            this.secHexField.grabFocus();
            this.secJumpCombo.updateUI();
        }
    }

    public void addListener(IGraphSearchFieldListener iGraphSearchFieldListener) {
        this.listeners.addListener(iGraphSearchFieldListener);
    }

    public void dispose() {
        this.searchField.removeMouseListener(this.mouseListener);
        this.priHexField.removeMouseListener(this.mouseListener);
        this.secHexField.removeMouseListener(this.mouseListener);
    }

    public GraphsContainer getGraphs() {
        return this.graphs;
    }

    public void jumpToIndex(int n2, ESide eSide) {
        BinDiffGraph binDiffGraph = eSide == ESide.PRIMARY ? this.graphs.getPrimaryGraph() : this.graphs.getSecondaryGraph();
        GraphSearcher graphSearcher = ((BinDiffGraph)binDiffGraph).getGraphSearcher();
        Object object = graphSearcher.getSubObjectResults().get(n2).getObject();
        if (binDiffGraph.getSettings().getDiffViewMode() == EDiffViewMode.COMBINED_VIEW) {
            if (object instanceof ZyGraphNode) {
                object = ((SingleDiffNode)object).getCombinedDiffNode();
            } else if (object instanceof ZyGraphEdge) {
                object = ((SingleDiffEdge)object).getCombinedDiffEdge();
            }
            binDiffGraph = this.graphs.getCombinedGraph();
        }
        GraphSeacherFunctions.jumpToResultObject(binDiffGraph, object, true);
    }

    public void notifySearchFieldListener() {
        for (IGraphSearchFieldListener iGraphSearchFieldListener : this.listeners) {
            iGraphSearchFieldListener.searched();
        }
    }

    public void setCaretIntoJumpToAddressField(ESide eSide) {
        this.updateSearchBox(eSide == ESide.PRIMARY ? ICON_JUMP_TO_PRIMARY_ADDRESS : ICON_JUMP_TO_SECONDARY_ADDRESS);
    }

    public void setCaretIntoSearchField() {
        if (this.searchField.hasFocus() && this.searchField.getCaret().isVisible()) {
            return;
        }
        this.updateSearchBox(ICON_NORMAL_SEARCH);
    }

    private final class InternalMouseListener
    extends MouseAdapter {
        private final JPopupMenu popupMenu;

        private InternalMouseListener() {
            this.popupMenu = GraphSearchField.this.createPopup();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getX() >= 0 && mouseEvent.getX() <= 38 && !this.popupMenu.isVisible()) {
                this.popupMenu.show(GraphSearchField.this, GraphSearchField.this.getX() - 1, GraphSearchField.this.getY() + GraphSearchField.this.getHeight() - 2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.popupMenu.isVisible() && mouseEvent.getX() > 38 && mouseEvent.getSource() instanceof JComponent && mouseEvent.getY() >= 0 && mouseEvent.getY() <= ((JComponent)mouseEvent.getSource()).getHeight()) {
                this.popupMenu.setVisible(false);
            }
        }
    }

    private final class CZoomToAddressAction
    extends AbstractAction {
        private CZoomToAddressAction() {
        }

        private boolean jumpToAddress(IAddress iAddress, ESide eSide) {
            String string;
            String string2 = string = eSide == ESide.PRIMARY ? GraphSearchField.this.priHexField.getText() : GraphSearchField.this.secHexField.getText();
            if (!string.isEmpty()) {
                if (eSide == ESide.PRIMARY) {
                    GraphSearchField.this.priJumpCombo.add(string);
                    GraphSearchField.this.priHexField.setCaretPosition(string.length());
                } else {
                    GraphSearchField.this.secJumpCombo.add(string);
                    GraphSearchField.this.secHexField.setCaretPosition(string.length());
                }
            }
            BinDiffGraph binDiffGraph = GraphSearchField.this.graphs.getCombinedGraph();
            if (GraphSearchField.this.controller.getGraphSettings().getDiffViewMode() == EDiffViewMode.NORMAL_VIEW) {
                binDiffGraph = eSide == ESide.PRIMARY ? GraphSearchField.this.graphs.getPrimaryGraph() : GraphSearchField.this.graphs.getSecondaryGraph();
            }
            ZyGraphNode zyGraphNode = null;
            if (binDiffGraph instanceof SingleGraph) {
                zyGraphNode = GraphAddressSearcher.searchAddress((SingleGraph)binDiffGraph, iAddress);
            } else if (binDiffGraph instanceof CombinedGraph) {
                zyGraphNode = GraphAddressSearcher.searchAddress(binDiffGraph, eSide, iAddress);
            }
            if (zyGraphNode != null) {
                GraphZoomer.zoomToNode(binDiffGraph, zyGraphNode);
            }
            return zyGraphNode != null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CAddress cAddress;
            if (actionEvent.getSource() == GraphSearchField.this.priHexField && GraphSearchField.this.priHexField.getText() != null) {
                if (GraphSearchField.this.priHexField.getText().isEmpty()) {
                    GraphSearchField.this.priHexField.setBackground(BACKGROUND_COLOR_SUCCESS);
                    return;
                }
                cAddress = new CAddress(GraphSearchField.this.priHexField.getText(), 16);
                GraphSearchField.this.priHexField.setBackground(this.jumpToAddress(cAddress, ESide.PRIMARY) ? BACKGROUND_COLOR_SUCCESS : BACKGROUND_COLOR_FAIL);
                GraphSearchField.this.priHexField.setFocusable(false);
                GraphSearchField.this.priHexField.setFocusable(true);
                GraphSearchField.this.priHexField.grabFocus();
                GraphSearchField.this.priHexField.updateUI();
            }
            if (actionEvent.getSource() == GraphSearchField.this.secHexField && GraphSearchField.this.secHexField.getText() != null) {
                if (GraphSearchField.this.secHexField.getText().isEmpty()) {
                    GraphSearchField.this.secHexField.setBackground(BACKGROUND_COLOR_SUCCESS);
                    return;
                }
                cAddress = new CAddress(GraphSearchField.this.secHexField.getText(), 16);
                GraphSearchField.this.secHexField.setBackground(this.jumpToAddress(cAddress, ESide.SECONDARY) ? BACKGROUND_COLOR_SUCCESS : BACKGROUND_COLOR_FAIL);
                GraphSearchField.this.secHexField.setFocusable(false);
                GraphSearchField.this.secHexField.setFocusable(true);
                GraphSearchField.this.secHexField.grabFocus();
                GraphSearchField.this.secHexField.updateUI();
            }
        }
    }

    private final class CSearchAction
    extends AbstractAction {
        private CSearchAction() {
        }

        private void centerNextSearchHit(boolean bl2, boolean bl3) {
            String string = GraphSearchField.this.searchField.getText();
            if (GraphSeacherFunctions.getHasChanged(GraphSearchField.this.graphs, string)) {
                if (!string.equals("")) {
                    this.iterateObjectResults(bl2, bl3);
                } else {
                    GraphSeacherFunctions.clearResults(GraphSearchField.this.graphs);
                    for (IGraphSearchFieldListener iGraphSearchFieldListener : GraphSearchField.this.listeners) {
                        iGraphSearchFieldListener.cleaned();
                    }
                }
                GraphSearchField.this.graphs.updateViews();
            } else {
                this.iterateObjectResults(bl2, bl3);
            }
        }

        private void iterateObjectResults(boolean bl2, boolean bl3) {
            if (!GraphSeacherFunctions.isEmpty(GraphSearchField.this.graphs)) {
                GraphSeacherFunctions.iterateObjectResults(GraphSearchField.this.graphs, bl2, bl3);
                GraphSearchField.this.graphs.updateViews();
            }
        }

        private void search(boolean bl2) {
            String string = GraphSearchField.this.searchField.getText();
            if (GraphSeacherFunctions.getHasChanged(GraphSearchField.this.graphs, string)) {
                if (!"".equals(string)) {
                    GraphSearchField.this.searchCombo.add(string);
                    GraphSearchField.this.searchField.setCaretPosition(GraphSearchField.this.searchField.getText().length());
                }
                try {
                    for (IGraphSearchFieldListener iGraphSearchFieldListener : GraphSearchField.this.listeners) {
                        iGraphSearchFieldListener.cleaned();
                    }
                    GraphSeacherFunctions.search(GraphSearchField.this.graphs, string);
                    if (GraphSeacherFunctions.isEmpty(GraphSearchField.this.graphs)) {
                        GraphSearchField.this.searchCombo.getEditor().getEditorComponent().setBackground(BACKGROUND_COLOR_FAIL);
                        GraphSearchField.this.clearSearchResultsButton.setIcon(ICON_CLEAR_GRAY);
                    } else {
                        GraphSearchField.this.searchCombo.getEditor().getEditorComponent().setBackground(BACKGROUND_COLOR_SUCCESS);
                        GraphSearchField.this.clearSearchResultsButton.setIcon(ICON_CLEAR);
                    }
                    GraphSeacherFunctions.highlightSubObjectResults(GraphSearchField.this.graphs);
                    GraphSeacherFunctions.jumpToFirstResultObject(GraphSearchField.this.graphs.getFocusedGraph(), bl2);
                    GraphSearchField.this.notifySearchFieldListener();
                    GraphSearchField.this.graphs.updateViews();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    CMessageBox.showInformation(GraphSearchField.this.controller.getMainWindow(), String.format("Invalid Regular Expression '%s'", string));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == GraphSearchField.this.searchField && GraphSearchField.this.searchField.getText() != null) {
                boolean bl2;
                if (GraphSearchField.this.searchField.getText().isEmpty()) {
                    GraphSeacherFunctions.clearResults(GraphSearchField.this.graphs);
                    GraphSearchField.this.searchField.setBackground(BACKGROUND_COLOR_SUCCESS);
                    GraphSearchField.this.clearSearchResultsButton.setIcon(ICON_CLEAR_GRAY);
                    for (IGraphSearchFieldListener iGraphSearchFieldListener : GraphSearchField.this.listeners) {
                        iGraphSearchFieldListener.cleaned();
                    }
                    return;
                }
                boolean bl3 = actionEvent.getModifiers() == 2 || actionEvent.getModifiers() == 3;
                boolean bl4 = bl2 = actionEvent.getModifiers() == 1 || actionEvent.getModifiers() == 3;
                if (GraphSeacherFunctions.getHasChanged(GraphSearchField.this.graphs, GraphSearchField.this.searchField.getText())) {
                    this.search(bl2);
                } else {
                    this.centerNextSearchHit(bl3, bl2);
                }
            }
        }
    }

    private final class CPopupChooserAction
    extends AbstractAction {
        private CPopupChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            GraphSearchField.this.updateSearchBox(jMenuItem.getIcon());
        }
    }

    private final class CEditorBorder
    extends AbstractBorder {
        private CEditorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return BORDER_INSETS;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            GraphSearchField.this.activeIcon.paintIcon(component, graphics, n2 + 4, n3 + 5);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n4, n5 - 1);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawRect(1, 1, n4 - 2, n5 - 3);
            graphics.translate(-n2, -n3);
        }
    }
}

