/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.components.closeablebuttontab;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.ICloseTabButtonListener;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.TabButton;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.TabLabel;
import com.google.security.zynamics.bindiff.gui.tabpanels.TabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.WorkspaceTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.projecttabpanel.actions.CloseAllViewsAction;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanel;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.actions.CloseViewAction;
import com.google.security.zynamics.bindiff.utils.GuiUtils;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class TabButtonComponent
extends JPanel {
    private final InternalMouseListener mouseListener = new InternalMouseListener();
    private final JTabbedPane pane;
    private final TabPanel tabPanel;
    private final TabButton closeButton;
    private final TabLabel label;

    public TabButtonComponent(JTabbedPane jTabbedPane, TabPanel tabPanel, Icon icon, boolean bl2) {
        super(new FlowLayout(0, 0, 0));
        this.pane = Preconditions.checkNotNull(jTabbedPane);
        this.tabPanel = Preconditions.checkNotNull(tabPanel);
        this.closeButton = new TabButton(jTabbedPane, this, bl2);
        this.label = new TabLabel(jTabbedPane, this);
        this.label.setFont(GuiHelper.getDefaultFont().deriveFont((float)GuiHelper.getDefaultFont().getSize() + 2.0f));
        if (icon != null) {
            this.label.setIcon(icon);
        }
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.add(this.label);
        if (bl2) {
            this.add(this.closeButton);
        }
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.addMouseListener(this.mouseListener);
    }

    public void addListener(ICloseTabButtonListener iCloseTabButtonListener) {
        this.closeButton.addListener(iCloseTabButtonListener);
    }

    public TabPanel getTabPanel() {
        return this.tabPanel;
    }

    public void removeListener(ICloseTabButtonListener iCloseTabButtonListener) {
        this.closeButton.removeListener(iCloseTabButtonListener);
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
        this.label.updateUI();
    }

    public void setTitle(String string) {
        this.label.setText(string);
        this.label.updateUI();
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private JPopupMenu popup = null;

        private InternalMouseListener() {
        }

        private void createPopupmenu() {
            if (this.popup == null) {
                this.popup = new JPopupMenu();
                this.popup.add(GuiUtils.buildMenuItem("Close View", new CloseViewAction((ViewTabPanel)TabButtonComponent.this.tabPanel)));
                WorkspaceTabPanelFunctions workspaceTabPanelFunctions = ((WorkspaceTabPanel)TabButtonComponent.this.pane.getComponentAt(0)).getController();
                this.popup.add(GuiUtils.buildMenuItem("Close Others", new CloseAllViewsAction(workspaceTabPanelFunctions, (ViewTabPanel)TabButtonComponent.this.tabPanel)));
                this.popup.add(GuiUtils.buildMenuItem("Close All", new CloseAllViewsAction(workspaceTabPanelFunctions)));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n2 = TabButtonComponent.this.pane.indexOfTabComponent(TabButtonComponent.this);
            TabButtonComponent.this.pane.setSelectedIndex(n2);
            if (n2 != 0 && mouseEvent.isPopupTrigger()) {
                this.createPopupmenu();
                this.popup.show(TabButtonComponent.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n2 = TabButtonComponent.this.pane.indexOfTabComponent(TabButtonComponent.this);
            if (n2 != 0 && mouseEvent.isPopupTrigger()) {
                this.createPopupmenu();
                this.popup.show(TabButtonComponent.this, mouseEvent.getX(), mouseEvent.getY());
            }
            if (mouseEvent.getButton() == 2 && mouseEvent.getClickCount() == 1) {
                CloseViewAction closeViewAction = new CloseViewAction((ViewTabPanel)TabButtonComponent.this.tabPanel);
                closeViewAction.execute();
            }
        }
    }
}

