/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.components.closeablebuttontab;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.gui.components.MessageBox;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.ICloseTabButtonListener;
import com.google.security.zynamics.bindiff.gui.components.closeablebuttontab.TabButtonComponent;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabButton
extends JButton {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final Color CROSS_COLOR = new Color(6119523);
    private static final Color CROSS_COLOR_ROLLOVER = new Color(6119782);
    private static final Color CROSS_BACKGROUND_ROLLOVER = new Color(15264493);
    private static final Color CROSS_BACKGROUND_PRESSED = new Color(14343392);
    private final ListenerProvider<ICloseTabButtonListener> closeTabButtonListeners = new ListenerProvider();
    private final InternalButtonListener buttonListener = new InternalButtonListener();
    private final InternalMouseListener mouseListener = new InternalMouseListener();
    private final JTabbedPane pane;
    private final TabButtonComponent tabButtonComponent;
    private final boolean enableClose;

    public TabButton(JTabbedPane jTabbedPane, TabButtonComponent tabButtonComponent, boolean bl2) {
        Preconditions.checkNotNull(jTabbedPane);
        Preconditions.checkNotNull(tabButtonComponent);
        this.pane = jTabbedPane;
        this.tabButtonComponent = tabButtonComponent;
        this.enableClose = bl2;
        int n2 = 14;
        this.setPreferredSize(new Dimension(14, 14));
        this.setToolTipText("Close View");
        this.setUI(new BasicButtonUI());
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.addMouseListener(this.mouseListener);
        this.setRolloverEnabled(true);
        this.addActionListener(this.buttonListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.enableClose) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = 4;
        Color color = CROSS_COLOR;
        if (this.getModel().isRollover()) {
            graphics2D.setColor(!this.getModel().isPressed() ? CROSS_BACKGROUND_ROLLOVER : CROSS_BACKGROUND_PRESSED);
            graphics2D.fillArc(0, 0, n2, n3, 0, 360);
            color = CROSS_COLOR_ROLLOVER;
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.5f));
        graphics2D.drawLine(3, 3, n2 - 4, n3 - 4);
        graphics2D.drawLine(3, n3 - 4, n2 - 4, 3);
        graphics2D.dispose();
    }

    public void addListener(ICloseTabButtonListener iCloseTabButtonListener) {
        this.closeTabButtonListeners.addListener(iCloseTabButtonListener);
    }

    public void removeListener(ICloseTabButtonListener iCloseTabButtonListener) {
        this.closeTabButtonListeners.removeListener(iCloseTabButtonListener);
    }

    private static class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBorderPainted(false);
            }
        }
    }

    private class InternalButtonListener
    implements ActionListener {
        private InternalButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2 = TabButton.this.pane.indexOfTabComponent(TabButton.this.tabButtonComponent);
            if (n2 == -1) {
                return;
            }
            for (ICloseTabButtonListener iCloseTabButtonListener : TabButton.this.closeTabButtonListeners) {
                try {
                    if (iCloseTabButtonListener.closing(TabButton.this.tabButtonComponent)) continue;
                    return;
                }
                catch (Exception exception) {
                    ((FluentLogger.Api)logger.at(Level.SEVERE).withCause(exception)).log("An error occurred while closing the tab");
                    MessageBox.showError(SwingUtilities.getWindowAncestor(TabButton.this), "An error occurred while closing the tab.");
                }
            }
        }
    }
}

