/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.gui.components;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;

public class TextComponentUtils {
    private TextComponentUtils() {
    }

    public static <T extends JTextComponent> T addDefaultEditorActions(T t2) {
        UndoManager undoManager = new UndoManager();
        t2.getDocument().addUndoableEditListener(undoManager);
        EditorActions editorActions = new EditorActions(undoManager);
        t2.setComponentPopupMenu(new DefaultEditorPopupMenu(editorActions));
        editorActions.getDelete().setEnabled(false);
        t2.addCaretListener(caretEvent -> {
            boolean bl2 = caretEvent.getDot() != caretEvent.getMark();
            boolean bl3 = Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
            editorActions.getUndo().setEnabled(undoManager.canUndo());
            editorActions.getRedo().setEnabled(undoManager.canRedo());
            editorActions.getCut().setEnabled(bl2);
            editorActions.getCopy().setEnabled(bl2);
            editorActions.getPaste().setEnabled(bl3);
            editorActions.getDelete().setEnabled(bl2);
            editorActions.getSelectAll().setEnabled(t2.getText().length() > 0);
        });
        t2.setSelectionStart(0);
        return t2;
    }

    public static class DefaultEditorPopupMenu
    extends JPopupMenu {
        public DefaultEditorPopupMenu(EditorActions editorActions) {
            JMenuItem jMenuItem = new JMenuItem(editorActions.getUndo());
            jMenuItem.setText("Undo");
            jMenuItem.setMnemonic('u');
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 128));
            this.add(jMenuItem);
            jMenuItem = new JMenuItem(editorActions.getRedo());
            jMenuItem.setText("Redo");
            jMenuItem.setMnemonic('r');
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 128));
            this.add(jMenuItem);
            this.add(new JSeparator());
            jMenuItem = new JMenuItem(editorActions.getCut());
            jMenuItem.setText("Cut");
            jMenuItem.setMnemonic('t');
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
            this.add(jMenuItem);
            jMenuItem = new JMenuItem(editorActions.getCopy());
            jMenuItem.setText("Copy");
            jMenuItem.setMnemonic('c');
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
            this.add(jMenuItem);
            jMenuItem = new JMenuItem(editorActions.getPaste());
            jMenuItem.setText("Paste");
            jMenuItem.setMnemonic('p');
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 128));
            this.add(jMenuItem);
            jMenuItem = new JMenuItem(editorActions.getDelete());
            jMenuItem.setText("Delete");
            jMenuItem.setMnemonic('d');
            this.add(jMenuItem);
            this.add(new JSeparator());
            jMenuItem = new JMenuItem(editorActions.getSelectAll());
            jMenuItem.setText("Select all");
            jMenuItem.setMnemonic('a');
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 128));
            this.add(jMenuItem);
        }
    }

    public static class EditorActions {
        private final UndoManager undoManager;
        private final TextAction undo = new TextAction("undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (undoManager != null && undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        };
        private final TextAction redo = new TextAction("redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (undoManager != null && undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        };
        private final TextAction cut = new DefaultEditorKit.CutAction();
        private final TextAction copy = new DefaultEditorKit.CopyAction();
        private final TextAction paste = new DefaultEditorKit.PasteAction();
        private final TextAction delete = new TextAction("delete"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getTextComponent(actionEvent).replaceSelection("");
            }
        };
        private final TextAction selectAll = new TextAction("select-all"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.getTextComponent(actionEvent).selectAll();
            }
        };

        public EditorActions(UndoManager undoManager) {
            this.undoManager = undoManager;
        }

        public TextAction getUndo() {
            return this.undo;
        }

        public TextAction getRedo() {
            return this.redo;
        }

        public TextAction getCut() {
            return this.cut;
        }

        public TextAction getCopy() {
            return this.copy;
        }

        public TextAction getPaste() {
            return this.paste;
        }

        public TextAction getDelete() {
            return this.delete;
        }

        public TextAction getSelectAll() {
            return this.selectAll;
        }
    }
}

