/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.settings;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.GraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.enums.EDiffViewMode;
import com.google.security.zynamics.bindiff.enums.EGraphSynchronization;
import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.settings.GraphDisplaySettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphLayoutSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphMouseSettings;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.bindiff.graph.settings.IGraphSettingsChangedListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.AbstractZyGraphSettings;
import java.util.logging.Level;

public class GraphSettings
extends AbstractZyGraphSettings {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    public static final int MAX_SELECTION_UNDO_CACHE = 30;
    private final ListenerProvider<IGraphSettingsChangedListener> settingsListeners = new ListenerProvider();
    private final GraphLayoutSettings layoutSettings;
    private final GraphProximityBrowsingSettings proximitySettings;
    private final GraphDisplaySettings displaySettings;
    private final GraphMouseSettings mouseSettings;
    private boolean drawBends;
    private boolean showScrollbars;
    private ESide focusSide;
    private EDiffViewMode diffViewMode;
    private EGraphSynchronization graphSync;

    public GraphSettings(GraphViewSettingsConfigItem graphViewSettingsConfigItem) {
        this.layoutSettings = new GraphLayoutSettings(graphViewSettingsConfigItem);
        this.proximitySettings = new GraphProximityBrowsingSettings(graphViewSettingsConfigItem);
        this.displaySettings = new GraphDisplaySettings(graphViewSettingsConfigItem);
        this.mouseSettings = new GraphMouseSettings(graphViewSettingsConfigItem);
        this.drawBends = graphViewSettingsConfigItem.getDrawBends();
        this.showScrollbars = graphViewSettingsConfigItem.getShowScrollbars();
        this.graphSync = graphViewSettingsConfigItem.getViewSynchronization() ? EGraphSynchronization.SYNC : EGraphSynchronization.ASYNC;
        this.focusSide = ESide.PRIMARY;
        this.diffViewMode = EDiffViewMode.NORMAL_VIEW;
    }

    public void addListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        this.settingsListeners.addListener(iGraphSettingsChangedListener);
        this.layoutSettings.addListener(iGraphSettingsChangedListener);
        this.proximitySettings.addListener(iGraphSettingsChangedListener);
        this.displaySettings.addListener(iGraphSettingsChangedListener);
        this.mouseSettings.addListener(iGraphSettingsChangedListener);
    }

    public EDiffViewMode getDiffViewMode() {
        return this.diffViewMode;
    }

    @Override
    public GraphDisplaySettings getDisplaySettings() {
        return this.displaySettings;
    }

    public boolean getDrawBends() {
        return this.drawBends;
    }

    public ESide getFocus() {
        return this.focusSide;
    }

    public EGraphSynchronization getGraphSyncMode() {
        return this.graphSync;
    }

    @Override
    public GraphLayoutSettings getLayoutSettings() {
        return this.layoutSettings;
    }

    @Override
    public GraphMouseSettings getMouseSettings() {
        return this.mouseSettings;
    }

    @Override
    public GraphProximityBrowsingSettings getProximitySettings() {
        return this.proximitySettings;
    }

    public boolean getShowScrollbars() {
        return this.showScrollbars;
    }

    public boolean isAsync() {
        return EGraphSynchronization.ASYNC == this.getGraphSyncMode();
    }

    public boolean isSync() {
        return EGraphSynchronization.SYNC == this.getGraphSyncMode();
    }

    public void removeListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.layoutSettings.removeListener(iGraphSettingsChangedListener);
            this.proximitySettings.removeListener(iGraphSettingsChangedListener);
            this.displaySettings.removeListener(iGraphSettingsChangedListener);
            this.mouseSettings.removeListener(iGraphSettingsChangedListener);
        }
        catch (Exception exception) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    public void setDiffViewMode(EDiffViewMode eDiffViewMode) {
        this.diffViewMode = eDiffViewMode;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.diffViewModeChanged(this);
        }
    }

    public void setDrawBends(boolean bl2) {
        if (this.drawBends == bl2) {
            return;
        }
        this.drawBends = bl2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.drawBendsChanged(this);
        }
    }

    public void setFocusSide(ESide eSide) {
        if (this.focusSide == eSide) {
            return;
        }
        this.focusSide = eSide;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.focusSideChanged(this);
        }
    }

    public void setGraphSyncMode(EGraphSynchronization eGraphSynchronization) {
        if (this.graphSync == eGraphSynchronization) {
            return;
        }
        this.graphSync = eGraphSynchronization;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.graphSyncChanged(this);
        }
    }

    public void setShowScrollbars(boolean bl2) {
        if (this.showScrollbars == bl2) {
            return;
        }
        this.showScrollbars = bl2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.showScrollbarsChanged(this);
        }
    }
}

