/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.settings;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.GraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.graph.settings.IGraphSettingsChangedListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettings;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IProximitySettingsListener;
import java.util.logging.Level;

public class GraphProximityBrowsingSettings
implements IProximitySettings {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private boolean proximityBrowsing;
    private boolean proximityBrowsingFrozen;
    private int proximityBrowsingChildDepth;
    private int proximityBrowsingParentDepth;
    private int autoProximityBrowsingActivationThreshold;
    private final ListenerProvider<IProximitySettingsListener> zySettingsListeners = new ListenerProvider();
    private final ListenerProvider<IGraphSettingsChangedListener> settingsListeners = new ListenerProvider();

    public GraphProximityBrowsingSettings(GraphViewSettingsConfigItem graphViewSettingsConfigItem) {
        this.proximityBrowsing = graphViewSettingsConfigItem.getProximityBrowsing();
        this.proximityBrowsingFrozen = false;
        this.proximityBrowsingChildDepth = graphViewSettingsConfigItem.getProximityBrowsingChildDepth();
        this.proximityBrowsingParentDepth = graphViewSettingsConfigItem.getProximityBrowsingParentDepth();
        this.autoProximityBrowsingActivationThreshold = graphViewSettingsConfigItem.getAutoProximityBrowsingActivationThreshold();
    }

    protected void addListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.addListener(iGraphSettingsChangedListener);
        }
        catch (Exception exception) {
            logger.at(Level.WARNING).log("Listener is already listening");
        }
    }

    protected void removeListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.removeListener(iGraphSettingsChangedListener);
        }
        catch (Exception exception) {
            logger.at(Level.WARNING).log("Listener was not listening.");
        }
    }

    @Override
    public void addListener(IProximitySettingsListener iProximitySettingsListener) {
        this.zySettingsListeners.addListener(iProximitySettingsListener);
    }

    public int getAutoProximityBrowsingActivationThreshold() {
        return this.autoProximityBrowsingActivationThreshold;
    }

    @Override
    public boolean getProximityBrowsing() {
        return this.proximityBrowsing;
    }

    @Override
    public int getProximityBrowsingChildren() {
        return this.proximityBrowsingChildDepth;
    }

    @Override
    public boolean getProximityBrowsingFrozen() {
        return this.proximityBrowsingFrozen;
    }

    @Override
    public int getProximityBrowsingParents() {
        return this.proximityBrowsingParentDepth;
    }

    @Override
    public void removeListener(IProximitySettingsListener iProximitySettingsListener) {
        this.zySettingsListeners.removeListener(iProximitySettingsListener);
    }

    public void setAutoProximityBrowsingActivationThreshold(int n2) {
        if (n2 == this.autoProximityBrowsingActivationThreshold) {
            return;
        }
        this.autoProximityBrowsingActivationThreshold = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.autoProximityBrowsingActivationThresholdChanged(this);
        }
    }

    public void setProximityBrowsing(boolean bl2) {
        if (this.proximityBrowsing == bl2) {
            return;
        }
        this.proximityBrowsing = bl2;
        for (IProximitySettingsListener object : this.zySettingsListeners) {
            object.changedProximityBrowsing(bl2);
        }
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.proximityBrowsingChanged(this);
        }
    }

    public void setProximityBrowsingChildren(int n2) {
        if (n2 == this.proximityBrowsingChildDepth) {
            return;
        }
        this.proximityBrowsingChildDepth = n2;
        for (IProximitySettingsListener object : this.zySettingsListeners) {
            object.changedProximityBrowsingDepth(n2, this.getProximityBrowsingParents());
        }
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.proximityBrowsingChildDepthChanged(this);
        }
    }

    public void setProximityBrowsingFrozen(boolean bl2) {
        if (this.proximityBrowsingFrozen == bl2) {
            return;
        }
        this.proximityBrowsingFrozen = bl2;
        for (IProximitySettingsListener object : this.zySettingsListeners) {
            object.changedProximityBrowsingFrozen(this.getProximityBrowsingFrozen());
        }
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.proximityBrowsingFrozenChanged(this);
        }
    }

    public void setProximityBrowsingParents(int n2) {
        if (n2 == this.proximityBrowsingParentDepth) {
            return;
        }
        this.proximityBrowsingParentDepth = n2;
        for (IProximitySettingsListener object : this.zySettingsListeners) {
            object.changedProximityBrowsingDepth(this.getProximityBrowsingChildren(), n2);
        }
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.proximityBrowsingParentDepthChanged(this);
        }
    }
}

