/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.settings;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.GraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.enums.EMouseAction;
import com.google.security.zynamics.bindiff.graph.settings.IGraphSettingsChangedListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.MouseWheelAction;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IMouseSettings;
import java.util.logging.Level;

public class GraphMouseSettings
implements IMouseSettings {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private EMouseAction mouseWheelAction;
    private int scrollSensitivity;
    private int zoomSensitivity;
    private final ListenerProvider<IGraphSettingsChangedListener> settingsListeners = new ListenerProvider();

    public GraphMouseSettings(GraphViewSettingsConfigItem graphViewSettingsConfigItem) {
        this.mouseWheelAction = graphViewSettingsConfigItem.getMouseWheelAction();
        this.scrollSensitivity = graphViewSettingsConfigItem.getScrollSensitivity();
        this.zoomSensitivity = graphViewSettingsConfigItem.getZoomSensitivity();
    }

    protected void addListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.addListener(iGraphSettingsChangedListener);
        }
        catch (Exception exception) {
            logger.at(Level.WARNING).log("Listener is already listening");
        }
    }

    protected void removeListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.removeListener(iGraphSettingsChangedListener);
        }
        catch (Exception exception) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    @Override
    public MouseWheelAction getMouseWheelAction() {
        return this.mouseWheelAction == EMouseAction.ZOOM ? MouseWheelAction.ZOOM : MouseWheelAction.SCROLL;
    }

    @Override
    public int getScrollSensitivity() {
        return this.scrollSensitivity;
    }

    @Override
    public int getZoomSensitivity() {
        return this.zoomSensitivity;
    }

    public void setMousewheelAction(EMouseAction eMouseAction) {
        if (this.mouseWheelAction == eMouseAction) {
            return;
        }
        this.mouseWheelAction = eMouseAction;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.mouseWheelActionChanged(this);
        }
    }

    public void setScrollSensitivity(int n2) {
        if (n2 == this.scrollSensitivity) {
            return;
        }
        this.scrollSensitivity = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.scrollSensitivityChanged(this);
        }
    }

    public void setZoomSensitivity(int n2) {
        if (n2 == this.zoomSensitivity) {
            return;
        }
        this.zoomSensitivity = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.zoomSensitivityChanged(this);
        }
    }
}

