/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.settings;

import a.f.c;
import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.GraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.enums.ECircularLayoutStyle;
import com.google.security.zynamics.bindiff.enums.EGraphLayout;
import com.google.security.zynamics.bindiff.enums.ELayoutOrientation;
import com.google.security.zynamics.bindiff.enums.EOrthogonalLayoutStyle;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCreator;
import com.google.security.zynamics.bindiff.graph.settings.IGraphSettingsChangedListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.settings.ILayoutSettings;
import java.util.logging.Level;

public class GraphLayoutSettings
implements ILayoutSettings {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private EGraphLayout defaultGraphLayout;
    private boolean autoLayouting;
    private int visibilityWarningThreshold;
    private int animationSpeed;
    private final int lastAnimationSpeed;
    private ELayoutOrientation hierarchicLayoutOrientation;
    private boolean hierarchicOrthogonalEdgeRouting;
    private int hierarchicLayoutMinLayerDistance;
    private int hierarchicLayoutMinNodeDistance;
    private int orthogonalLayoutMinNodeDistance;
    private ELayoutOrientation orthogonalLayoutOrientation;
    private EOrthogonalLayoutStyle orthogonalLayoutStyle;
    private ECircularLayoutStyle circularLayoutStyle;
    private int circularLayoutMinNodeDistance;
    private c currentLayouter;
    private final ListenerProvider<IGraphSettingsChangedListener> settingsListeners = new ListenerProvider();

    public GraphLayoutSettings(GraphViewSettingsConfigItem graphViewSettingsConfigItem) {
        this.defaultGraphLayout = graphViewSettingsConfigItem.getDefaultGraphLayout();
        this.autoLayouting = graphViewSettingsConfigItem.getAutoLayouting();
        this.visibilityWarningThreshold = graphViewSettingsConfigItem.getVisibilityWarningThreshold();
        this.lastAnimationSpeed = this.animationSpeed = graphViewSettingsConfigItem.getAnimationSpeed();
        this.circularLayoutStyle = graphViewSettingsConfigItem.getCircularLayoutStyle();
        this.circularLayoutMinNodeDistance = graphViewSettingsConfigItem.getCircularMinimumNodeDistance();
        this.hierarchicOrthogonalEdgeRouting = graphViewSettingsConfigItem.getHierarchicalOrthogonalEdgeRouting();
        this.hierarchicLayoutOrientation = ELayoutOrientation.getEnum(graphViewSettingsConfigItem.getHierarchicalOrientation());
        this.hierarchicLayoutMinLayerDistance = graphViewSettingsConfigItem.getHierarchicalMinimumNodeDistance();
        this.hierarchicLayoutMinNodeDistance = graphViewSettingsConfigItem.getHierarchicalMinimumLayerDistance();
        this.orthogonalLayoutStyle = graphViewSettingsConfigItem.getOrthogonalLayoutStyle();
        this.orthogonalLayoutOrientation = graphViewSettingsConfigItem.getOrthogonalOrientation();
        this.orthogonalLayoutMinNodeDistance = graphViewSettingsConfigItem.getOrthogonalMinimumNodeDistance();
        this.updateLayouter();
    }

    private void setCurrentLayouter(c c2) {
        Preconditions.checkNotNull(c2);
        this.currentLayouter = c2;
    }

    protected void addListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.addListener(iGraphSettingsChangedListener);
        }
        catch (IllegalStateException illegalStateException) {
            logger.at(Level.WARNING).log("Listener is already listening");
        }
    }

    protected void removeListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.removeListener(iGraphSettingsChangedListener);
        }
        catch (IllegalStateException illegalStateException) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    @Override
    public boolean getAnimateLayout() {
        return this.animationSpeed > 0;
    }

    @Override
    public int getAnimateLayoutEdgeThreshold() {
        return 0;
    }

    @Override
    public int getAnimateLayoutNodeThreshold() {
        return 0;
    }

    @Override
    public boolean getAutomaticLayouting() {
        return this.autoLayouting;
    }

    public ECircularLayoutStyle getCircularLayoutStyle() {
        return this.circularLayoutStyle;
    }

    @Override
    public c getCurrentLayouter() {
        return this.currentLayouter;
    }

    public EGraphLayout getDefaultGraphLayout() {
        return this.defaultGraphLayout;
    }

    public boolean getHierarchicalOrthogonalEdgeRouting() {
        return this.hierarchicOrthogonalEdgeRouting;
    }

    public ELayoutOrientation getHierarchicOrientation() {
        return this.hierarchicLayoutOrientation;
    }

    public long getMinimumCircularNodeDistance() {
        return this.circularLayoutMinNodeDistance;
    }

    public long getMinimumHierarchicLayerDistance() {
        return this.hierarchicLayoutMinLayerDistance;
    }

    public long getMinimumHierarchicNodeDistance() {
        return this.hierarchicLayoutMinNodeDistance;
    }

    public long getMinimumOrthogonalNodeDistance() {
        return this.orthogonalLayoutMinNodeDistance;
    }

    public ELayoutOrientation getOrthogonalLayoutOrientation() {
        return this.orthogonalLayoutOrientation;
    }

    public EOrthogonalLayoutStyle getOrthogonalLayoutStyle() {
        return this.orthogonalLayoutStyle;
    }

    public int getVisibilityWarningThreshold() {
        return this.visibilityWarningThreshold;
    }

    public void setAnimateLayout(boolean bl2) {
        if (bl2 == this.animationSpeed > 0) {
            return;
        }
        this.animationSpeed = this.lastAnimationSpeed;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.layoutAnimationChanged(this);
        }
    }

    public void setAutomaticLayouting(boolean bl2) {
        if (this.autoLayouting == bl2) {
            return;
        }
        this.autoLayouting = bl2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.autoLayoutChanged(this);
        }
    }

    public void setCircularLayoutStyle(ECircularLayoutStyle eCircularLayoutStyle) {
        if (eCircularLayoutStyle == this.circularLayoutStyle) {
            return;
        }
        this.circularLayoutStyle = eCircularLayoutStyle;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.circularLayoutStyleChanged(this);
        }
    }

    public void setDefaultGraphLayout(EGraphLayout eGraphLayout) {
        if (eGraphLayout == this.defaultGraphLayout) {
            return;
        }
        this.defaultGraphLayout = eGraphLayout;
        this.updateLayouter();
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.layoutChanged(this);
        }
    }

    public void setHierarchicOrientation(ELayoutOrientation eLayoutOrientation) {
        if (eLayoutOrientation == this.hierarchicLayoutOrientation) {
            return;
        }
        this.hierarchicLayoutOrientation = eLayoutOrientation;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.hierarchicalLayoutOrientationChanged(this);
        }
    }

    public void setHierarchicOrthogonalEdgeRouting(boolean bl2) {
        if (bl2 == this.hierarchicOrthogonalEdgeRouting) {
            return;
        }
        this.hierarchicOrthogonalEdgeRouting = bl2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.hierarchicalOrthogonalEdgeRoutingChanged(this);
        }
    }

    public void setMinimumCircularNodeDistance(int n2) {
        if (n2 == this.circularLayoutMinNodeDistance) {
            return;
        }
        this.circularLayoutMinNodeDistance = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.circularLayoutMinNodeDistanceChanged(this);
        }
    }

    public void setMinimumHierarchicLayerDistance(int n2) {
        if (n2 == this.hierarchicLayoutMinLayerDistance) {
            return;
        }
        this.hierarchicLayoutMinLayerDistance = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.hierarchicalLayoutMinLayerDistanceChanged(this);
        }
    }

    public void setMinimumHierarchicNodeDistance(int n2) {
        if (n2 == this.hierarchicLayoutMinNodeDistance) {
            return;
        }
        this.hierarchicLayoutMinNodeDistance = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.hierarchicalLayoutMinNodeDistanceChanged(this);
        }
    }

    public void setMinimumOrthogonalNodeDistance(int n2) {
        if (n2 == this.orthogonalLayoutMinNodeDistance) {
            return;
        }
        this.orthogonalLayoutMinNodeDistance = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.orthogonalLayoutMinNodeDistanceChanged(this);
        }
    }

    public void setOrthogonalLayoutOrientation(ELayoutOrientation eLayoutOrientation) {
        if (eLayoutOrientation == this.orthogonalLayoutOrientation) {
            return;
        }
        this.orthogonalLayoutOrientation = eLayoutOrientation;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.orthogonalLayoutOrientationChanged(this);
        }
    }

    public void setOrthogonalLayoutStyle(EOrthogonalLayoutStyle eOrthogonalLayoutStyle) {
        if (eOrthogonalLayoutStyle == this.orthogonalLayoutStyle) {
            return;
        }
        this.orthogonalLayoutStyle = eOrthogonalLayoutStyle;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.orthogonalLayoutStyleChanged(this);
        }
    }

    public void setVisibilityWarningThreshold(int n2) {
        if (this.visibilityWarningThreshold == n2) {
            return;
        }
        this.visibilityWarningThreshold = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.visibilityWarningThresholdChanged(this);
        }
    }

    public void updateLayouter() {
        if (this.getDefaultGraphLayout() == EGraphLayout.HIERARCHICAL) {
            this.setCurrentLayouter(LayoutCreator.getHierarchicalLayout(this));
        } else if (this.getDefaultGraphLayout() == EGraphLayout.ORTHOGONAL) {
            this.setCurrentLayouter(LayoutCreator.getOrthogonalLayout(this));
        } else {
            this.setCurrentLayouter(LayoutCreator.getCircularLayout(this));
        }
    }
}

