/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.settings;

import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.config.GraphViewSettingsConfigItem;
import com.google.security.zynamics.bindiff.graph.settings.IGraphSettingsChangedListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IDisplaySettings;
import com.google.security.zynamics.zylib.gui.zygraph.settings.IDisplaySettingsListener;
import java.util.logging.Level;

public class GraphDisplaySettings
implements IDisplaySettings {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private int animationSpeed;
    private final ListenerProvider<IDisplaySettingsListener> zySettingsListeners = new ListenerProvider();
    private final ListenerProvider<IGraphSettingsChangedListener> settingsListeners = new ListenerProvider();

    public GraphDisplaySettings(GraphViewSettingsConfigItem graphViewSettingsConfigItem) {
        this.animationSpeed = graphViewSettingsConfigItem.getAnimationSpeed();
    }

    protected void addListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.addListener(iGraphSettingsChangedListener);
        }
        catch (RuntimeException runtimeException) {
            logger.at(Level.WARNING).log("Listener is already listening");
        }
    }

    protected void removeListener(IGraphSettingsChangedListener iGraphSettingsChangedListener) {
        try {
            this.settingsListeners.removeListener(iGraphSettingsChangedListener);
        }
        catch (RuntimeException runtimeException) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    @Override
    public void addListener(IDisplaySettingsListener iDisplaySettingsListener) {
        this.zySettingsListeners.addListener(iDisplaySettingsListener);
    }

    @Override
    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    @Override
    public boolean getMagnifyingGlassMode() {
        return false;
    }

    @Override
    public void removeListener(IDisplaySettingsListener iDisplaySettingsListener) {
        this.zySettingsListeners.removeListener(iDisplaySettingsListener);
    }

    public void setAnimationSpeed(int n2) {
        if (this.animationSpeed == n2) {
            return;
        }
        this.animationSpeed = n2;
        for (IGraphSettingsChangedListener iGraphSettingsChangedListener : this.settingsListeners) {
            iGraphSettingsChangedListener.animationSpeedChanged(this);
        }
    }

    @Override
    public void setMagnifyingGlassMode(boolean bl2) {
    }
}

