/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.searchers;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.edges.CombinedDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperDiffEdge;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.searchers.EdgeSearcher;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSeacherFunctions;
import com.google.security.zynamics.bindiff.graph.searchers.NodeSearcher;
import com.google.security.zynamics.bindiff.graph.searchers.SearchResult;
import com.google.security.zynamics.bindiff.graph.searchers.SearchResultComparator;
import com.google.security.zynamics.bindiff.graph.sorters.SearchResultSorter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class GraphSearcher {
    private boolean isRegEx;
    private boolean isCaseSensitive;
    private boolean onlySelected;
    private boolean onlyVisible;
    private boolean changed = true;
    private boolean isAfterLast = false;
    private boolean isBeforeFirst = false;
    private int currentSearchIndex = -1;
    private String lastSearchString;
    private final List<SearchResult> subObjectResults = new ArrayList<SearchResult>();
    private List<Object> objectResults = new ArrayList<Object>();

    private List<ZyGraphEdge<?, ?, ?>> filterValidEdgesNodes(List<? extends ZyGraphEdge<?, ?, ?>> list) {
        ArrayList arrayList = new ArrayList();
        for (ZyGraphEdge<?, ?, ?> zyGraphEdge : list) {
            if (!(zyGraphEdge instanceof SingleDiffEdge) && !(zyGraphEdge instanceof CombinedDiffEdge) && !(zyGraphEdge instanceof SuperDiffEdge)) continue;
            arrayList.add(zyGraphEdge);
        }
        return arrayList;
    }

    private List<ZyGraphNode<?>> filterValidNodes(List<? extends ZyGraphNode<?>> list) {
        ArrayList arrayList = new ArrayList();
        for (ZyGraphNode<?> zyGraphNode : list) {
            if (!(zyGraphNode instanceof SingleDiffNode) && !(zyGraphNode instanceof CombinedDiffNode) && !(zyGraphNode instanceof SuperDiffNode)) continue;
            arrayList.add(zyGraphNode);
        }
        return arrayList;
    }

    private void searchAll(List<ZyGraphNode<?>> list, List<ZyGraphEdge<?, ?, ?>> list2, String string) {
        for (ZyGraphNode<?> object : list) {
            this.searchNode(object, string);
        }
        for (ZyGraphEdge zyGraphEdge : list2) {
            this.searchEdge(zyGraphEdge, string);
        }
    }

    private void searchEdge(ZyGraphEdge<?, ?, ?> zyGraphEdge, String string) {
        this.subObjectResults.addAll(EdgeSearcher.search(zyGraphEdge, string, this.isRegEx, this.isCaseSensitive));
        if (this.subObjectResults.size() != 0) {
            this.currentSearchIndex = 0;
        }
    }

    private void searchNode(ZyGraphNode<?> zyGraphNode, String string) {
        this.subObjectResults.addAll(NodeSearcher.search(zyGraphNode, string, this.isRegEx, this.isCaseSensitive));
        if (this.subObjectResults.size() != 0) {
            this.currentSearchIndex = 0;
        }
    }

    private void searchSelected(List<ZyGraphNode<?>> list, List<ZyGraphEdge<?, ?, ?>> list2, String string) {
        for (ZyGraphNode<?> object : list) {
            if (!object.isSelected()) continue;
            this.searchNode(object, string);
        }
        for (ZyGraphEdge zyGraphEdge : list2) {
            if (!zyGraphEdge.isSelected()) continue;
            this.searchEdge(zyGraphEdge, string);
        }
    }

    private void searchVisible(List<ZyGraphNode<?>> list, List<ZyGraphEdge<?, ?, ?>> list2, String string) {
        for (ZyGraphNode<?> object : list) {
            if (!object.isVisible()) continue;
            this.searchNode(object, string);
        }
        for (ZyGraphEdge zyGraphEdge : list2) {
            if (!zyGraphEdge.isVisible()) continue;
            this.searchEdge(zyGraphEdge, string);
        }
    }

    protected void setLastSearchString(String string) {
        this.changed = false;
        this.lastSearchString = string;
    }

    protected void setObjectResult(List<Object> list) {
        this.objectResults = list;
    }

    protected void sortResult() {
        Collections.sort(this.subObjectResults, new SearchResultComparator());
        HashSet<Object> hashSet = new HashSet<Object>();
        for (SearchResult searchResult : this.subObjectResults) {
            hashSet.add(searchResult.getObject());
        }
        this.objectResults = SearchResultSorter.getSortedList(hashSet, ESide.PRIMARY);
    }

    public void clearResults() {
        for (SearchResult searchResult : this.subObjectResults) {
            GraphSeacherFunctions.removeSubObjectHightlighing(searchResult);
        }
        this.subObjectResults.clear();
        this.objectResults.clear();
        this.currentSearchIndex = 0;
        this.lastSearchString = "";
        this.changed = false;
    }

    public Object current() {
        return this.objectResults.size() == 0 ? null : this.objectResults.get(this.currentSearchIndex);
    }

    public boolean getHasChanged(String string) {
        return this.changed || !string.equals(this.lastSearchString);
    }

    public String getLastSearchString() {
        return this.lastSearchString;
    }

    public List<Object> getObjectResults() {
        return this.objectResults;
    }

    public List<SearchResult> getSubObjectResults() {
        return this.subObjectResults;
    }

    public boolean isAfterLast() {
        return this.isAfterLast;
    }

    public boolean isBeforeFirst() {
        return this.isBeforeFirst;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public boolean isSelectedOnly() {
        return this.onlySelected;
    }

    public boolean isVisibleOnly() {
        return this.onlyVisible;
    }

    public void next() {
        if (this.current() == null) {
            return;
        }
        ++this.currentSearchIndex;
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        if (this.currentSearchIndex == this.objectResults.size()) {
            this.currentSearchIndex = 0;
            this.isAfterLast = true;
        }
    }

    public void previous() {
        if (this.current() == null) {
            return;
        }
        --this.currentSearchIndex;
        this.isBeforeFirst = false;
        this.isAfterLast = false;
        if (this.currentSearchIndex < 0) {
            this.currentSearchIndex = this.objectResults.size() - 1;
            this.isBeforeFirst = true;
        }
    }

    public void search(List<? extends ZyGraphNode<?>> list, List<? extends ZyGraphEdge<?, ?, ?>> list2, String string) {
        List<ZyGraphNode<?>> list3 = this.filterValidNodes(list);
        List<ZyGraphEdge<?, ?, ?>> list4 = this.filterValidEdgesNodes(list2);
        this.setLastSearchString(string);
        if (this.onlySelected) {
            this.searchSelected(list3, list4, string);
        } else if (this.onlyVisible) {
            this.searchVisible(list3, list4, string);
        } else {
            this.searchAll(list3, list4, string);
        }
        this.sortResult();
    }

    public void setCaseSensitive(boolean bl2) {
        this.isCaseSensitive = bl2;
        this.changed = true;
    }

    public void setOnlySelected(boolean bl2) {
        this.onlySelected = bl2;
        this.changed = true;
    }

    public void setOnlyVisible(boolean bl2) {
        this.onlyVisible = bl2;
        this.changed = true;
    }

    public void setRegEx(boolean bl2) {
        this.isRegEx = bl2;
        this.changed = true;
    }
}

