/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.searchers;

import com.google.security.zynamics.bindiff.enums.ESide;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.helpers.GraphMover;
import com.google.security.zynamics.bindiff.graph.helpers.GraphZoomer;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.searchers.CombinedGraphSearcher;
import com.google.security.zynamics.bindiff.graph.searchers.GraphSearcher;
import com.google.security.zynamics.bindiff.graph.searchers.SearchResult;
import com.google.security.zynamics.bindiff.graph.searchers.SuperGraphSearcher;
import com.google.security.zynamics.bindiff.resources.Colors;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.CStyleRunData;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.Color;
import java.awt.Window;
import java.util.List;
import javax.swing.SwingUtilities;

public class GraphSeacherFunctions {
    private static void markResults(SearchResult searchResult, boolean bl2) {
        Color color = bl2 ? Colors.SEARCH_HIGHLIGHT_COLOR : searchResult.getOriginalBorderColor();
        SingleDiffNode singleDiffNode = (SingleDiffNode)searchResult.getObject();
        if (bl2) {
            singleDiffNode.setBackgroundColor(searchResult.getLine(), searchResult.getPosition(), searchResult.getLength(), Colors.SEARCH_HIGHLIGHT_COLOR);
        } else {
            int n2 = searchResult.getLine();
            for (CStyleRunData object2 : searchResult.getOriginalTextBackgroundStyleRun()) {
                Color color2 = object2.getColor();
                ESide eSide = singleDiffNode.getSide();
                if (color2 != null) {
                    if (singleDiffNode.isSelected()) {
                        if (eSide == ESide.PRIMARY && color2 == Colors.PRIMARY_BASE || eSide == ESide.SECONDARY && color2 == Colors.SECONDARY_BASE) {
                            color2 = color2.darker();
                        }
                    } else if (eSide == ESide.PRIMARY && color2.equals(Colors.PRIMARY_BASE.darker())) {
                        color2 = Colors.PRIMARY_BASE;
                    } else if (eSide == ESide.SECONDARY && color2 == Colors.SECONDARY_BASE) {
                        color2 = Colors.SECONDARY_BASE;
                    }
                }
                singleDiffNode.setBackgroundColor(n2, object2.getStart(), object2.getLength(), color2);
            }
        }
        singleDiffNode.getRealizer().getRealizer().setLineColor(color);
        CombinedDiffNode combinedDiffNode = singleDiffNode.getCombinedDiffNode();
        SingleDiffNode singleDiffNode2 = combinedDiffNode.getPrimaryDiffNode();
        SingleDiffNode singleDiffNode3 = combinedDiffNode.getSecondaryDiffNode();
        combinedDiffNode.getRealizer().getRealizer().setLineColor(color);
        if (singleDiffNode2 != null && singleDiffNode3 != null && !singleDiffNode2.getRealizer().getRealizer().getLineColor().equals(singleDiffNode3.getRealizer().getRealizer().getLineColor())) {
            combinedDiffNode.getRealizer().getRealizer().setLineColor(Colors.MIXED_BASE_COLOR.darker());
        }
    }

    public static void clearResults(GraphsContainer graphsContainer) {
        for (BinDiffGraph<?, ?> binDiffGraph : graphsContainer) {
            binDiffGraph.getGraphSearcher().clearResults();
        }
    }

    public static boolean getHasChanged(GraphsContainer graphsContainer, String string) {
        for (BinDiffGraph<?, ?> binDiffGraph : graphsContainer) {
            if (!binDiffGraph.getGraphSearcher().getHasChanged(string)) continue;
            return true;
        }
        return false;
    }

    public static void highlightResults(List<SearchResult> list) {
        for (SearchResult searchResult : list) {
            GraphSeacherFunctions.markResults(searchResult, true);
        }
    }

    public static void highlightSubObjectResults(GraphsContainer graphsContainer) {
        for (BinDiffGraph<?, ?> binDiffGraph : graphsContainer) {
            if (!(binDiffGraph instanceof SingleGraph)) continue;
            for (SearchResult searchResult : binDiffGraph.getGraphSearcher().getSubObjectResults()) {
                GraphSeacherFunctions.markResults(searchResult, true);
            }
        }
    }

    public static boolean isEmpty(GraphsContainer graphsContainer) {
        for (BinDiffGraph<?, ?> binDiffGraph : graphsContainer) {
            if (binDiffGraph.getGraphSearcher().getObjectResults().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void iterateObjectResults(GraphsContainer graphsContainer, boolean bl2, boolean bl3) {
        Object object;
        BinDiffGraph<?, ?> binDiffGraph = graphsContainer.getFocusedGraph();
        GraphSearcher graphSearcher = binDiffGraph.getGraphSearcher();
        Window window = SwingUtilities.getWindowAncestor(graphsContainer.getCombinedGraph().getView());
        if (bl2) {
            graphSearcher.previous();
            if (graphSearcher.isBeforeFirst()) {
                CMessageBox.showInformation(window, "All search results were displayed. Going back to the last one.");
            }
        } else {
            graphSearcher.next();
            if (graphSearcher.isAfterLast()) {
                CMessageBox.showInformation(window, "All search results were displayed. Going back to the first one.");
            }
        }
        if ((object = graphSearcher.current()) == null) {
            return;
        }
        GraphSeacherFunctions.jumpToResultObject(binDiffGraph, object, bl3);
    }

    public static void jumpToFirstResultObject(BinDiffGraph<?, ?> binDiffGraph, boolean bl2) {
        List<Object> list = binDiffGraph.getGraphSearcher().getObjectResults();
        if (!list.isEmpty()) {
            Object object = list.get(0);
            GraphSeacherFunctions.jumpToResultObject(binDiffGraph, object, bl2);
        }
    }

    public static <NodeType extends ZyGraphNode<?>> void jumpToResultObject(BinDiffGraph<?, ?> singleGraph, Object object, boolean bl2) {
        if (object == null) {
            return;
        }
        if (object instanceof ZyGraphNode) {
            SingleGraph singleGraph2 = singleGraph;
            Object object2 = object;
            if (singleGraph instanceof SuperGraph) {
                singleGraph2 = singleGraph.getPrimaryGraph();
                object2 = ((SuperDiffNode)object).getPrimaryDiffNode();
                if (object2 == null) {
                    singleGraph2 = singleGraph.getSecondaryGraph();
                    object2 = ((SuperDiffNode)object).getSecondaryDiffNode();
                }
            }
            if (bl2) {
                GraphZoomer.zoomToNode(singleGraph2, (ZyGraphNode)object2);
            } else {
                GraphMover.moveToNode(singleGraph2, (ZyGraphNode)object2);
            }
        }
    }

    public static void removeHightlighing(List<SearchResult> list) {
        for (SearchResult searchResult : list) {
            GraphSeacherFunctions.removeSubObjectHightlighing(searchResult);
        }
    }

    public static void removeSubObjectHightlighing(SearchResult searchResult) {
        GraphSeacherFunctions.markResults(searchResult, false);
    }

    public static void search(GraphsContainer graphsContainer, String string) {
        Object object;
        Object object2;
        Object object32;
        GraphSeacherFunctions.clearResults(graphsContainer);
        for (Object object32 : graphsContainer) {
            object2 = GraphHelpers.getNodes(object32);
            object = GraphHelpers.getEdges(object32);
            ((BinDiffGraph)object32).getGraphSearcher().search((List<? extends ZyGraphNode<?>>)object2, (List<? extends ZyGraphEdge<?, ?, ?>>)object, string);
        }
        List<Object> list = graphsContainer.getPrimaryGraph().getGraphSearcher().getObjectResults();
        object32 = graphsContainer.getSecondaryGraph().getGraphSearcher().getObjectResults();
        object2 = graphsContainer.getSuperGraph();
        object = graphsContainer.getCombinedGraph();
        ((SuperGraphSearcher)((SuperGraph)object2).getGraphSearcher()).setObjectResults((SuperGraph)object2, list, (List<Object>)object32);
        ((CombinedGraphSearcher)((CombinedGraph)object).getGraphSearcher()).setObjectResults((CombinedGraph)object, list, (List<Object>)object32);
    }
}

