/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.edges.SuperViewEdge;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.CViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class SuperViewNode
extends CViewNode<SuperViewEdge<? extends SuperViewNode>>
implements IGraphNode<SuperViewNode> {
    private final List<SuperViewNode> children = new ArrayList<SuperViewNode>();
    private final List<SuperViewNode> parents = new ArrayList<SuperViewNode>();
    private final CombinedViewNode combinedNode;

    public SuperViewNode(CombinedViewNode combinedViewNode) {
        super(-1, 0.0, 0.0, 0.0, 0.0, Color.WHITE, Color.BLACK, false, true);
        Preconditions.checkNotNull(combinedViewNode);
        this.combinedNode = combinedViewNode;
    }

    public static void link(SuperViewNode superViewNode, SuperViewNode superViewNode2) {
        superViewNode.getChildren().add(superViewNode2);
        superViewNode2.getParents().add(superViewNode);
    }

    public static void unlink(SuperViewNode superViewNode, SuperViewNode superViewNode2) {
        superViewNode.getChildren().remove(superViewNode2);
        superViewNode2.getParents().remove(superViewNode);
    }

    @Override
    public List<SuperViewNode> getChildren() {
        return this.children;
    }

    public CombinedViewNode getCombinedNode() {
        return this.combinedNode;
    }

    @Override
    public IGroupNode<?, ?> getParentGroup() {
        return null;
    }

    @Override
    public List<SuperViewNode> getParents() {
        return this.parents;
    }

    public void removeNode() {
        for (SuperViewEdge superViewEdge : this.getIncomingEdges()) {
            SuperViewNode.unlink((SuperViewNode)superViewEdge.getSource(), (SuperViewNode)superViewEdge.getTarget());
            ((SuperViewNode)superViewEdge.getSource()).removeOutgoingEdge(superViewEdge);
            ((SuperViewNode)superViewEdge.getTarget()).removeIncomingEdge(superViewEdge);
        }
        for (SuperViewEdge superViewEdge : this.getOutgoingEdges()) {
            SuperViewNode.unlink((SuperViewNode)superViewEdge.getSource(), (SuperViewNode)superViewEdge.getTarget());
            ((SuperViewNode)superViewEdge.getSource()).removeOutgoingEdge(superViewEdge);
            ((SuperViewNode)superViewEdge.getTarget()).removeIncomingEdge(superViewEdge);
        }
    }
}

