/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.nodes;

import a.c.p;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperViewNode;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.util.ArrayList;
import java.util.List;

public class SuperDiffNode
extends ZyGraphNode<SuperViewNode>
implements IGraphNode<SuperDiffNode> {
    private final SingleDiffNode primaryDiffNode;
    private final SingleDiffNode secondaryDiffNode;
    private CombinedDiffNode combinedDiffNode;
    private final List<SuperDiffNode> parents = new ArrayList<SuperDiffNode>();
    private final List<SuperDiffNode> children = new ArrayList<SuperDiffNode>();

    public SuperDiffNode(p p2, IZyNodeRealizer iZyNodeRealizer, SuperViewNode superViewNode, SingleDiffNode singleDiffNode, SingleDiffNode singleDiffNode2) {
        super(p2, iZyNodeRealizer, superViewNode);
        Preconditions.checkArgument(singleDiffNode != null || singleDiffNode2 != null, "Primary diff node and secondary diff node cannot be both be null.");
        this.primaryDiffNode = singleDiffNode;
        this.secondaryDiffNode = singleDiffNode2;
    }

    public static void link(SuperDiffNode superDiffNode, SuperDiffNode superDiffNode2) {
        superDiffNode.children.add(superDiffNode2);
        superDiffNode2.parents.add(superDiffNode);
    }

    public static void unlink(SuperDiffNode superDiffNode, SuperDiffNode superDiffNode2) {
        superDiffNode.children.remove(superDiffNode2);
        superDiffNode2.parents.remove(superDiffNode);
    }

    @Override
    public SuperViewNode getRawNode() {
        return (SuperViewNode)super.getRawNode();
    }

    @Override
    public List<SuperDiffNode> getChildren() {
        return new ArrayList<SuperDiffNode>(this.children);
    }

    public CombinedDiffNode getCombinedDiffNode() {
        return this.combinedDiffNode;
    }

    public CombinedViewNode getCombinedRawNode() {
        return this.combinedDiffNode != null ? this.combinedDiffNode.getRawNode() : null;
    }

    @Override
    public List<SuperDiffNode> getParents() {
        return new ArrayList<SuperDiffNode>(this.parents);
    }

    public SingleDiffNode getPrimaryDiffNode() {
        return this.primaryDiffNode;
    }

    public SingleViewNode getPrimaryRawNode() {
        return this.primaryDiffNode != null ? this.primaryDiffNode.getRawNode() : null;
    }

    public SingleDiffNode getSecondaryDiffNode() {
        return this.secondaryDiffNode;
    }

    public SingleViewNode getSecondaryRawNode() {
        return this.secondaryDiffNode != null ? this.secondaryDiffNode.getRawNode() : null;
    }

    public void setCombinedDiffNode(CombinedDiffNode combinedDiffNode) {
        Preconditions.checkNotNull(combinedDiffNode);
        this.combinedDiffNode = combinedDiffNode;
    }
}

