/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.listeners;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.synchronizer.GraphViewCanvasSynchronizer;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class SingleViewCanvasListener
implements PropertyChangeListener {
    private final SingleGraph graph;
    private final ViewTabPanelFunctions viewPanelController;
    private boolean suppressUpdateGraph = false;

    protected SingleViewCanvasListener(ViewTabPanelFunctions viewTabPanelFunctions, SingleGraph singleGraph) {
        this.viewPanelController = Preconditions.checkNotNull(viewTabPanelFunctions);
        this.graph = Preconditions.checkNotNull(singleGraph);
        this.addListener();
    }

    public void addListener() {
        this.graph.getView().getCanvasComponent().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.graph.getGraphType() == EGraphType.FLOWGRAPH && this.graph.getFunctionAddress() == null) {
            return;
        }
        if ("Zoom".equals(propertyChangeEvent.getPropertyName())) {
            GraphViewCanvasSynchronizer.adoptZoom(this.viewPanelController.getGraphListenerManager(), this.graph);
        } else if ("ViewPoint".equals(propertyChangeEvent.getPropertyName())) {
            GraphViewCanvasSynchronizer.adoptViewPoint(this.viewPanelController.getGraphListenerManager(), this.graph, (Point2D.Double)propertyChangeEvent.getOldValue(), this.suppressUpdateGraph);
        }
    }

    public void removeListener() {
        this.graph.getView().getCanvasComponent().removePropertyChangeListener(this);
    }

    public void suppressUpdateGraph(boolean bl2) {
        this.suppressUpdateGraph = bl2;
    }
}

