/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.listeners;

import a.h.N;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.edges.SingleDiffEdge;
import com.google.security.zynamics.bindiff.graph.eventhandlers.GraphLayoutEventHandler;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.synchronizer.GraphMouseHoverSynchronizer;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.CallGraphPopupMenu;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.FlowGraphPopupMenu;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawBasicBlock;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.IZyGraphListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class SingleGraphMouseListener
implements IZyGraphListener<SingleDiffNode, SingleDiffEdge> {
    private final SingleGraph graph;
    private final ViewTabPanelFunctions controller;

    protected SingleGraphMouseListener(ViewTabPanelFunctions viewTabPanelFunctions, SingleGraph singleGraph) {
        this.controller = Preconditions.checkNotNull(viewTabPanelFunctions);
        this.graph = Preconditions.checkNotNull(singleGraph);
        this.addListener();
    }

    public void addListener() {
        this.graph.addListener(this);
    }

    @Override
    public void edgeClicked(SingleDiffEdge singleDiffEdge, MouseEvent mouseEvent, double d2, double d3) {
    }

    @Override
    public void edgeLabelEntered(N n2, MouseEvent mouseEvent) {
    }

    @Override
    public void edgeLabelExited(N n2) {
    }

    @Override
    public void nodeClicked(SingleDiffNode singleDiffNode, MouseEvent mouseEvent, double d2, double d3) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (singleDiffNode.getRawNode() instanceof RawFunction) {
                CallGraphPopupMenu callGraphPopupMenu = new CallGraphPopupMenu(this.controller, this.graph, singleDiffNode);
                callGraphPopupMenu.show(this.graph.getView(), mouseEvent.getX(), mouseEvent.getY());
            } else if (singleDiffNode.getRawNode() instanceof RawBasicBlock) {
                FlowGraphPopupMenu flowGraphPopupMenu = new FlowGraphPopupMenu(this.controller, this.graph, singleDiffNode);
                flowGraphPopupMenu.show(this.graph.getView(), mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && this.graph.getGraphType() == EGraphType.CALLGRAPH) {
            this.controller.openFlowgraphsViews(singleDiffNode);
        }
    }

    @Override
    public void nodeEntered(SingleDiffNode singleDiffNode, MouseEvent mouseEvent) {
        if (singleDiffNode != null) {
            GraphMouseHoverSynchronizer.adoptHoveredNodeState(this.graph, singleDiffNode);
        }
    }

    @Override
    public void nodeHovered(SingleDiffNode singleDiffNode, double d2, double d3) {
    }

    @Override
    public void nodeLeft(SingleDiffNode singleDiffNode) {
        if (singleDiffNode != null) {
            GraphMouseHoverSynchronizer.adoptHoveredNodeState(this.graph, singleDiffNode);
        }
    }

    @Override
    public void proximityBrowserNodeClicked(ZyProximityNode<?> zyProximityNode, MouseEvent mouseEvent, double d2, double d3) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            GraphLayoutEventHandler.handleProximityNodeClickedEvent(this.graph, zyProximityNode);
        }
    }

    public void removeListener() {
        this.graph.removeListener(this);
    }
}

