/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.listeners;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraph;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.eventhandlers.GraphLayoutEventHandler;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphVisibilityListener;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;

public class GraphsIntermediateListeners {
    private final BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> graph;
    private final ListenerProvider<IZyGraphSelectionListener> intermediateSelectionListener = new ListenerProvider();
    private final ListenerProvider<IZyGraphVisibilityListener> intermediateVisibilityListener = new ListenerProvider();
    private final InternalGraphSelectionListener selectionListener;
    private final InternalGraphVisibilityListener visibilityListener;
    private InternalGraphSelectionListener[] savedSelectionListeners = new InternalGraphSelectionListener[4];
    private InternalGraphVisibilityListener[] savedVisibilityListeners = new InternalGraphVisibilityListener[4];

    public GraphsIntermediateListeners(BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        Preconditions.checkNotNull(binDiffGraph);
        this.graph = binDiffGraph;
        this.selectionListener = new InternalGraphSelectionListener(binDiffGraph);
        this.visibilityListener = new InternalGraphVisibilityListener(binDiffGraph);
        this.addListeners();
    }

    public static void notifyIntermediateSelectionListeners(BinDiffGraph<?, ?> binDiffGraph) {
        if (binDiffGraph.getSettings().isSync()) {
            binDiffGraph.getPrimaryGraph().getIntermediateListeners().notifyIntermediateSelectionListener();
            binDiffGraph.getSecondaryGraph().getIntermediateListeners().notifyIntermediateSelectionListener();
            binDiffGraph.getCombinedGraph().getIntermediateListeners().notifyIntermediateSelectionListener();
            binDiffGraph.getSuperGraph().getIntermediateListeners().notifyIntermediateSelectionListener();
        } else {
            binDiffGraph.getIntermediateListeners().notifyIntermediateSelectionListener();
        }
    }

    public static void notifyIntermediateVisibilityListeners(BinDiffGraph<?, ?> binDiffGraph) {
        if (binDiffGraph.getSettings().isSync()) {
            binDiffGraph.getPrimaryGraph().getIntermediateListeners().notifyIntermediateVisibilityListener();
            binDiffGraph.getSecondaryGraph().getIntermediateListeners().notifyIntermediateVisibilityListener();
            binDiffGraph.getCombinedGraph().getIntermediateListeners().notifyIntermediateVisibilityListener();
            binDiffGraph.getSuperGraph().getIntermediateListeners().notifyIntermediateVisibilityListener();
        } else {
            binDiffGraph.getIntermediateListeners().notifyIntermediateSelectionListener();
        }
    }

    private void addListeners() {
        this.graph.addListener(this.selectionListener);
        this.graph.addListener(this.visibilityListener);
    }

    private GraphsIntermediateListeners getGraphIntermediateListener(EGraph eGraph) {
        Preconditions.checkNotNull(this.graph);
        switch (eGraph) {
            case PRIMARY_GRAPH: {
                Preconditions.checkNotNull(this.graph.getPrimaryGraph());
                return this.graph.getPrimaryGraph().getIntermediateListeners();
            }
            case SECONDARY_GRAPH: {
                Preconditions.checkNotNull(this.graph.getSecondaryGraph());
                return this.graph.getSecondaryGraph().getIntermediateListeners();
            }
            case COMBINED_GRAPH: {
                Preconditions.checkNotNull(this.graph.getCombinedGraph());
                return this.graph.getCombinedGraph().getIntermediateListeners();
            }
            case SUPER_GRAPH: {
                Preconditions.checkNotNull(this.graph.getSuperGraph());
                return this.graph.getSuperGraph().getIntermediateListeners();
            }
        }
        throw new IllegalStateException();
    }

    private InternalGraphSelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    private InternalGraphVisibilityListener getVisibilityListener() {
        return this.visibilityListener;
    }

    private void notifyIntermediateSelectionListener() {
        for (IZyGraphSelectionListener iZyGraphSelectionListener : this.intermediateSelectionListener) {
            iZyGraphSelectionListener.selectionChanged();
        }
    }

    private void notifyIntermediateVisibilityListener() {
        for (IZyGraphVisibilityListener iZyGraphVisibilityListener : this.intermediateVisibilityListener) {
            iZyGraphVisibilityListener.visibilityChanged();
        }
    }

    public void addIntermediateListener(IZyGraphSelectionListener iZyGraphSelectionListener) {
        this.intermediateSelectionListener.addListener(iZyGraphSelectionListener);
    }

    public void addIntermediateListener(IZyGraphVisibilityListener iZyGraphVisibilityListener) {
        this.intermediateVisibilityListener.addListener(iZyGraphVisibilityListener);
    }

    public void blockZyLibSelectionListeners() {
        this.savedSelectionListeners[0] = this.getGraphIntermediateListener(EGraph.PRIMARY_GRAPH).getSelectionListener();
        this.savedSelectionListeners[1] = this.getGraphIntermediateListener(EGraph.SECONDARY_GRAPH).getSelectionListener();
        this.savedSelectionListeners[2] = this.getGraphIntermediateListener(EGraph.SUPER_GRAPH).getSelectionListener();
        this.savedSelectionListeners[3] = this.getGraphIntermediateListener(EGraph.COMBINED_GRAPH).getSelectionListener();
        for (InternalGraphSelectionListener internalGraphSelectionListener : this.savedSelectionListeners) {
            if (internalGraphSelectionListener == null) continue;
            internalGraphSelectionListener.getGraph().removeListener(internalGraphSelectionListener);
        }
    }

    public void blockZyLibVisibilityListeners() {
        this.savedVisibilityListeners[0] = this.getGraphIntermediateListener(EGraph.PRIMARY_GRAPH).getVisibilityListener();
        this.savedVisibilityListeners[1] = this.getGraphIntermediateListener(EGraph.SECONDARY_GRAPH).getVisibilityListener();
        this.savedVisibilityListeners[2] = this.getGraphIntermediateListener(EGraph.SUPER_GRAPH).getVisibilityListener();
        this.savedVisibilityListeners[3] = this.getGraphIntermediateListener(EGraph.COMBINED_GRAPH).getVisibilityListener();
        for (InternalGraphVisibilityListener internalGraphVisibilityListener : this.savedVisibilityListeners) {
            if (internalGraphVisibilityListener == null) continue;
            internalGraphVisibilityListener.getGraph().removeListener(internalGraphVisibilityListener);
        }
    }

    public void dispose() {
        this.graph.removeListener(this.selectionListener);
        this.graph.removeListener(this.visibilityListener);
        this.savedSelectionListeners = null;
        this.savedVisibilityListeners = null;
    }

    public void freeZyLibSelectionListeners() {
        for (InternalGraphSelectionListener internalGraphSelectionListener : this.savedSelectionListeners) {
            if (internalGraphSelectionListener == null) continue;
            internalGraphSelectionListener.getGraph().addListener(internalGraphSelectionListener);
        }
    }

    public void freeZyLibVisibilityListeners() {
        for (InternalGraphVisibilityListener internalGraphVisibilityListener : this.savedVisibilityListeners) {
            if (internalGraphVisibilityListener == null) continue;
            internalGraphVisibilityListener.getGraph().addListener(internalGraphVisibilityListener);
        }
    }

    public void removeIntermediateListener(IZyGraphSelectionListener iZyGraphSelectionListener) {
        this.intermediateSelectionListener.removeListener(iZyGraphSelectionListener);
    }

    public void removeIntermediateListener(IZyGraphVisibilityListener iZyGraphVisibilityListener) {
        this.intermediateVisibilityListener.removeListener(iZyGraphVisibilityListener);
    }

    private static class InternalGraphVisibilityListener
    implements IZyGraphVisibilityListener {
        private final BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> graph;

        private InternalGraphVisibilityListener(BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
            this.graph = binDiffGraph;
        }

        public BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> getGraph() {
            return this.graph;
        }

        @Override
        public void nodeDeleted() {
        }

        @Override
        public void visibilityChanged() {
        }
    }

    private static class InternalGraphSelectionListener
    implements IZyGraphSelectionListener {
        private final BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> graph;

        private InternalGraphSelectionListener(BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
            this.graph = binDiffGraph;
        }

        public BinDiffGraph<ZyGraphNode<? extends IViewNode<?>>, ?> getGraph() {
            return this.graph;
        }

        @Override
        public void selectionChanged() {
            GraphLayoutEventHandler.handleSelectionChangedEvent(this.graph, true);
        }
    }
}

