/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.listeners;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.GraphsContainer;
import com.google.security.zynamics.bindiff.graph.listeners.CombinedGraphMouseListener;
import com.google.security.zynamics.bindiff.graph.listeners.SingleGraphMouseListener;
import com.google.security.zynamics.bindiff.graph.listeners.SingleViewCanvasListener;
import com.google.security.zynamics.bindiff.graph.listeners.SingleViewFocusListener;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import java.util.logging.Level;

public class GraphViewsListenerManager {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final GraphsContainer graphs;
    private final SingleViewCanvasListener primaryViewCanvasListener;
    private final SingleViewCanvasListener secondaryViewCanvasListener;
    private final CombinedGraphMouseListener combinedGraphMouseListener;
    private final SingleGraphMouseListener primaryGraphMouseListener;
    private final SingleGraphMouseListener secondaryGraphMouseListener;
    private final SingleViewFocusListener primaryViewFocusListener;
    private final SingleViewFocusListener secondaryViewFocusListener;

    public GraphViewsListenerManager(GraphsContainer graphsContainer, ViewTabPanelFunctions viewTabPanelFunctions) {
        Preconditions.checkNotNull(viewTabPanelFunctions);
        this.graphs = Preconditions.checkNotNull(graphsContainer);
        this.primaryViewCanvasListener = new SingleViewCanvasListener(viewTabPanelFunctions, graphsContainer.getPrimaryGraph());
        this.secondaryViewCanvasListener = new SingleViewCanvasListener(viewTabPanelFunctions, graphsContainer.getSecondaryGraph());
        this.combinedGraphMouseListener = new CombinedGraphMouseListener(viewTabPanelFunctions, graphsContainer.getCombinedGraph());
        this.primaryGraphMouseListener = new SingleGraphMouseListener(viewTabPanelFunctions, graphsContainer.getPrimaryGraph());
        this.secondaryGraphMouseListener = new SingleGraphMouseListener(viewTabPanelFunctions, graphsContainer.getSecondaryGraph());
        this.primaryViewFocusListener = new SingleViewFocusListener(viewTabPanelFunctions, graphsContainer.getPrimaryGraph());
        this.secondaryViewFocusListener = new SingleViewFocusListener(viewTabPanelFunctions, graphsContainer.getSecondaryGraph());
    }

    public void addGraphMouseListener(BinDiffGraph<?, ?> binDiffGraph) {
        if (binDiffGraph == this.graphs.getPrimaryGraph()) {
            this.primaryGraphMouseListener.addListener();
        } else if (binDiffGraph == this.graphs.getSecondaryGraph()) {
            this.secondaryGraphMouseListener.addListener();
        } else if (binDiffGraph == this.graphs.getCombinedGraph()) {
            this.combinedGraphMouseListener.addListener();
        } else {
            logger.at(Level.WARNING).log("Unknown graph! Add graph mouse listener was ignored.");
        }
    }

    public void addViewCanvasListener(BinDiffGraph<?, ?> binDiffGraph) {
        if (binDiffGraph == this.graphs.getPrimaryGraph()) {
            this.primaryViewCanvasListener.addListener();
        } else if (binDiffGraph == this.graphs.getSecondaryGraph()) {
            this.secondaryViewCanvasListener.addListener();
        } else {
            logger.at(Level.WARNING).log("Unknown graph! Add view canvas listener was ignored.");
        }
    }

    public void addViewFocusListener(BinDiffGraph<?, ?> binDiffGraph) {
        if (binDiffGraph == this.graphs.getPrimaryGraph()) {
            this.primaryViewFocusListener.addListener();
        } else if (binDiffGraph == this.graphs.getSecondaryGraph()) {
            this.secondaryViewFocusListener.addListener();
        } else {
            logger.at(Level.WARNING).log("Unknown graph! Add graph view focus listener was ignored.");
        }
    }

    public void dispose() {
        this.removeViewCanvasListener(this.graphs.getPrimaryGraph());
        this.removeViewCanvasListener(this.graphs.getSecondaryGraph());
        this.removeViewFocusListener(this.graphs.getPrimaryGraph());
        this.removeViewFocusListener(this.graphs.getSecondaryGraph());
        this.removeGraphMouseListener(this.graphs.getPrimaryGraph());
        this.removeGraphMouseListener(this.graphs.getSecondaryGraph());
        this.removeGraphMouseListener(this.graphs.getCombinedGraph());
    }

    public void removeGraphMouseListener(BinDiffGraph<?, ?> binDiffGraph) {
        try {
            if (binDiffGraph == this.graphs.getPrimaryGraph()) {
                this.primaryGraphMouseListener.removeListener();
            } else if (binDiffGraph == this.graphs.getSecondaryGraph()) {
                this.secondaryGraphMouseListener.removeListener();
            } else if (binDiffGraph == this.graphs.getCombinedGraph()) {
                this.combinedGraphMouseListener.removeListener();
            } else {
                logger.at(Level.WARNING).log("Unknown graph! Remove graph mouse listener was ignored.");
            }
        }
        catch (IllegalStateException illegalStateException) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    public void removeViewCanvasListener(BinDiffGraph<?, ?> binDiffGraph) {
        try {
            if (binDiffGraph == this.graphs.getPrimaryGraph()) {
                this.primaryViewCanvasListener.removeListener();
            } else if (binDiffGraph == this.graphs.getSecondaryGraph()) {
                this.secondaryViewCanvasListener.removeListener();
            } else {
                logger.at(Level.WARNING).log("Unknown graph! Remove view canvas listener was ignored.");
            }
        }
        catch (IllegalStateException illegalStateException) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    public void removeViewFocusListener(BinDiffGraph<?, ?> binDiffGraph) {
        try {
            if (binDiffGraph == this.graphs.getPrimaryGraph()) {
                this.primaryViewFocusListener.addListener();
            } else if (binDiffGraph == this.graphs.getSecondaryGraph()) {
                this.secondaryViewFocusListener.addListener();
            } else {
                logger.at(Level.WARNING).log("Unknown graph! Add graph view focus listener was ignored.");
            }
        }
        catch (IllegalStateException illegalStateException) {
            logger.at(Level.WARNING).log("Listener was not listening");
        }
    }

    public void suppressUpdating(boolean bl2) {
        this.primaryViewCanvasListener.suppressUpdateGraph(bl2);
        this.secondaryViewCanvasListener.suppressUpdateGraph(bl2);
    }
}

