/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.listeners;

import a.h.N;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.enums.EGraphType;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.edges.CombinedDiffEdge;
import com.google.security.zynamics.bindiff.graph.eventhandlers.GraphLayoutEventHandler;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.ViewTabPanelFunctions;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.CallGraphPopupMenu;
import com.google.security.zynamics.bindiff.gui.tabpanels.viewtabpanel.popupmenus.FlowGraphPopupMenu;
import com.google.security.zynamics.bindiff.project.rawcallgraph.RawCombinedFunction;
import com.google.security.zynamics.bindiff.project.rawflowgraph.RawCombinedBasicBlock;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.IZyGraphListener;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class CombinedGraphMouseListener
implements IZyGraphListener<CombinedDiffNode, CombinedDiffEdge> {
    private final CombinedGraph graph;
    private final ViewTabPanelFunctions controller;

    protected CombinedGraphMouseListener(ViewTabPanelFunctions viewTabPanelFunctions, CombinedGraph combinedGraph) {
        this.controller = Preconditions.checkNotNull(viewTabPanelFunctions);
        this.graph = Preconditions.checkNotNull(combinedGraph);
        this.addListener();
    }

    public void addListener() {
        this.graph.addListener(this);
    }

    @Override
    public void edgeClicked(CombinedDiffEdge combinedDiffEdge, MouseEvent mouseEvent, double d2, double d3) {
    }

    @Override
    public void edgeLabelEntered(N n2, MouseEvent mouseEvent) {
    }

    @Override
    public void edgeLabelExited(N n2) {
    }

    @Override
    public void nodeClicked(CombinedDiffNode combinedDiffNode, MouseEvent mouseEvent, double d2, double d3) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (combinedDiffNode.getRawNode() instanceof RawCombinedFunction) {
                CallGraphPopupMenu callGraphPopupMenu = new CallGraphPopupMenu(this.controller, this.graph, combinedDiffNode);
                callGraphPopupMenu.show(this.graph.getView(), mouseEvent.getX(), mouseEvent.getY());
            } else if (combinedDiffNode.getRawNode() instanceof RawCombinedBasicBlock) {
                FlowGraphPopupMenu flowGraphPopupMenu = new FlowGraphPopupMenu(this.controller, this.graph, combinedDiffNode);
                flowGraphPopupMenu.show(this.graph.getView(), mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && this.graph.getGraphType() == EGraphType.CALLGRAPH) {
            this.controller.openFlowgraphsViews(combinedDiffNode);
        }
    }

    @Override
    public void nodeEntered(CombinedDiffNode combinedDiffNode, MouseEvent mouseEvent) {
    }

    @Override
    public void nodeHovered(CombinedDiffNode combinedDiffNode, double d2, double d3) {
    }

    @Override
    public void nodeLeft(CombinedDiffNode combinedDiffNode) {
    }

    @Override
    public void proximityBrowserNodeClicked(ZyProximityNode<?> zyProximityNode, MouseEvent mouseEvent, double d2, double d3) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            GraphLayoutEventHandler.handleProximityNodeClickedEvent(this.graph, zyProximityNode);
        }
    }

    public void removeListener() {
        this.graph.removeListener(this);
    }
}

