/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import a.c.p;
import com.google.common.base.Preconditions;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.ProximityBrowser;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.layout.LayoutCommandHelper;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphLayoutUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.GraphViewUpdater;
import com.google.security.zynamics.bindiff.graph.layout.commands.ProximityBrowserUpdater;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.helpers.ProximityHelper;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class ProximityNodeClickedUpdater
implements ICommand {
    private final BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> graph;
    private final ZyProximityNode<?> proximityNode;

    public ProximityNodeClickedUpdater(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        this.graph = Preconditions.checkNotNull(binDiffGraph);
        this.proximityNode = Preconditions.checkNotNull(zyProximityNode);
    }

    private static Set<ZyGraphNode<? extends IViewNode<?>>> getNodesToShow(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        p p2 = zyProximityNode.getNode();
        HashSet hashSet = new HashSet();
        p p3 = p2.aR().aU();
        Object NodeType2 = binDiffGraph.getNode(p3);
        if (zyProximityNode.indegree() == 1) {
            for (ZyGraphNode<?> zyGraphNode : ((ZyGraphNode)NodeType2).getChildren()) {
                if (zyGraphNode.isVisible() || ProximityHelper.isProximityNode(binDiffGraph.getGraph(), zyGraphNode.getNode())) continue;
                hashSet.add(zyGraphNode);
            }
        }
        if (zyProximityNode.outdegree() == 1) {
            for (ZyGraphNode<?> zyGraphNode : ((ZyGraphNode)NodeType2).getParents()) {
                if (zyGraphNode.isVisible() || ProximityHelper.isProximityNode(binDiffGraph.getGraph(), zyGraphNode.getNode())) continue;
                hashSet.add(zyGraphNode);
            }
        }
        return hashSet;
    }

    private static boolean showProximityNodeClickedVisibilityWarningDialog(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        int n2;
        int n3 = ProximityNodeClickedUpdater.getNodesToShowCount(binDiffGraph, zyProximityNode);
        if (n3 > (n2 = binDiffGraph.getSettings().getLayoutSettings().getVisibilityWarningThreshold())) {
            int n4 = CMessageBox.showYesNoQuestion(BinDiffGraph.getParentWindow(binDiffGraph), String.format("The selected operation makes %d more nodes visible. Do you want to continue?", n3));
            return n4 == 0;
        }
        return true;
    }

    private static void updateVisibility(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        Set<ZyGraphNode<IViewNode<?>>> set = ProximityNodeClickedUpdater.getNodesToShow(binDiffGraph, zyProximityNode);
        if (binDiffGraph.getSettings().isSync()) {
            HashSet<CombinedDiffNode> hashSet = new HashSet<CombinedDiffNode>();
            HashSet<SuperDiffNode> hashSet2 = new HashSet<SuperDiffNode>();
            for (ZyGraphNode<? extends IViewNode<?>> zyGraphNode : set) {
                if (zyGraphNode instanceof SingleDiffNode) {
                    hashSet.add(((SingleDiffNode)zyGraphNode).getCombinedDiffNode());
                    hashSet2.add(((SingleDiffNode)zyGraphNode).getSuperDiffNode());
                    continue;
                }
                if (!(zyGraphNode instanceof CombinedDiffNode)) continue;
                hashSet.add((CombinedDiffNode)zyGraphNode);
                hashSet2.add(((CombinedDiffNode)zyGraphNode).getSuperDiffNode());
            }
            binDiffGraph.getCombinedGraph().showNodes(hashSet, false);
            binDiffGraph.getSuperGraph().showNodes(hashSet2, false);
        } else {
            for (ZyGraphNode<IViewNode<?>> zyGraphNode : set) {
                if (!(zyGraphNode instanceof SingleDiffNode) && !(zyGraphNode instanceof CombinedDiffNode)) continue;
                zyGraphNode.getRawNode().setVisible(true);
            }
        }
    }

    protected static void updateProximityNodes(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph) {
        if (binDiffGraph.getSettings().isSync()) {
            ((ProximityBrowser)binDiffGraph.getCombinedGraph().getProximityBrowser()).deleteProximityBrowsingNodes();
            ((ProximityBrowser)binDiffGraph.getSuperGraph().getProximityBrowser()).deleteProximityBrowsingNodes();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(binDiffGraph.getCombinedGraph().getNodes());
            ArrayList arrayList2 = new ArrayList();
            arrayList2.addAll(binDiffGraph.getSuperGraph().getNodes());
            ((ProximityBrowser)binDiffGraph.getCombinedGraph().getProximityBrowser()).createProximityBrowsingNodes(arrayList);
            ((ProximityBrowser)binDiffGraph.getSuperGraph().getProximityBrowser()).createProximityBrowsingNodes(arrayList2);
            ProximityBrowserUpdater.adoptSuperGraphVisibility(binDiffGraph.getSuperGraph());
            ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getPrimaryGraph());
            ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getSecondaryGraph());
            ProximityBrowserUpdater.createProximityNodesAndEdges(binDiffGraph.getSuperGraph());
        } else {
            ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph);
            if (binDiffGraph instanceof SingleGraph) {
                ProximityBrowserUpdater.createProximityNodesAndEdges((SingleGraph)binDiffGraph);
            } else if (binDiffGraph instanceof CombinedGraph) {
                ProximityBrowserUpdater.createProximityNodesAndEdges((CombinedGraph)binDiffGraph);
            }
        }
    }

    public static void executeStatic(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        if (ProximityNodeClickedUpdater.showProximityNodeClickedVisibilityWarningDialog(binDiffGraph, zyProximityNode)) {
            ProximityNodeClickedUpdater.updateVisibility(binDiffGraph, zyProximityNode);
            ProximityNodeClickedUpdater.updateProximityNodes(binDiffGraph);
            GraphViewUpdater.updateViews(binDiffGraph);
            GraphsIntermediateListeners.notifyIntermediateVisibilityListeners(binDiffGraph);
            if (LayoutCommandHelper.isAutolayout(binDiffGraph)) {
                GraphLayoutUpdater.executeStatic(binDiffGraph, true);
            }
        }
    }

    public static int getNodesToShowCount(BinDiffGraph<? extends ZyGraphNode<? extends IViewNode<?>>, ?> binDiffGraph, ZyProximityNode<?> zyProximityNode) {
        return ProximityNodeClickedUpdater.getNodesToShow(binDiffGraph, zyProximityNode).size();
    }

    @Override
    public void execute() {
        ProximityNodeClickedUpdater.executeStatic(this.graph, this.proximityNode);
    }
}

