/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.bindiff.graph.layout.commands;

import a.c.d;
import a.c.p;
import a.c.q;
import a.h.U;
import a.h.bQ;
import a.h.ba;
import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.security.zynamics.bindiff.exceptions.GraphLayoutException;
import com.google.security.zynamics.bindiff.graph.BinDiffGraph;
import com.google.security.zynamics.bindiff.graph.CombinedGraph;
import com.google.security.zynamics.bindiff.graph.ProximityBrowser;
import com.google.security.zynamics.bindiff.graph.SingleGraph;
import com.google.security.zynamics.bindiff.graph.SuperGraph;
import com.google.security.zynamics.bindiff.graph.edges.SingleViewEdge;
import com.google.security.zynamics.bindiff.graph.edges.SuperDiffEdge;
import com.google.security.zynamics.bindiff.graph.listeners.GraphsIntermediateListeners;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.CombinedViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleDiffNode;
import com.google.security.zynamics.bindiff.graph.nodes.SingleViewNode;
import com.google.security.zynamics.bindiff.graph.nodes.SuperDiffNode;
import com.google.security.zynamics.bindiff.graph.settings.GraphProximityBrowsingSettings;
import com.google.security.zynamics.zylib.gui.zygraph.edges.ZyEdgeData;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.NodeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ZyNodeData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.types.common.ICommand;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyInfoEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyProximityNodeRealizer;
import java.awt.Font;
import java.util.HashSet;
import java.util.logging.Level;

public final class ProximityBrowserUpdater
implements ICommand {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> referenceGraph;

    public ProximityBrowserUpdater(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        this.referenceGraph = Preconditions.checkNotNull(binDiffGraph);
    }

    private static void createNewProximityNodeAndEdge(U u2, CombinedDiffNode combinedDiffNode, int n2, boolean bl2) {
        if (n2 == 0) {
            return;
        }
        ZyLabelContent zyLabelContent = new ZyLabelContent(null);
        zyLabelContent.addLineContent(new ZyLineContent(String.valueOf(n2), new Font("New Courier", 0, 12), null));
        ZyProximityNodeRealizer zyProximityNodeRealizer = new ZyProximityNodeRealizer(zyLabelContent);
        p p2 = u2.k(zyProximityNodeRealizer);
        ZyProximityNode<CombinedViewNode> zyProximityNode = new ZyProximityNode<CombinedViewNode>(p2, zyProximityNodeRealizer, combinedDiffNode, bl2);
        ZyNodeData<ZyProximityNode<CombinedViewNode>> zyNodeData = new ZyNodeData<ZyProximityNode<CombinedViewNode>>(zyProximityNode);
        zyProximityNodeRealizer.setUserData(zyNodeData);
        ZyEdgeRealizer<ZyInfoEdge> zyEdgeRealizer = new ZyEdgeRealizer<ZyInfoEdge>(new ZyLabelContent(null), null);
        zyEdgeRealizer.setLineType(ba.aLi);
        d d2 = u2.a(bl2 ? combinedDiffNode.getNode() : zyProximityNode.getNode(), bl2 ? zyProximityNode.getNode() : combinedDiffNode.getNode(), zyEdgeRealizer);
        ZyInfoEdge zyInfoEdge = new ZyInfoEdge(bl2 ? combinedDiffNode : zyProximityNode, bl2 ? zyProximityNode : combinedDiffNode, d2, zyEdgeRealizer);
        ZyEdgeData<ZyInfoEdge> zyEdgeData = new ZyEdgeData<ZyInfoEdge>(zyInfoEdge);
        zyEdgeRealizer.setUserData(zyEdgeData);
    }

    private static void createNewProximityNodeAndEdge(U u2, SingleDiffNode singleDiffNode, int n2, boolean bl2) {
        if (n2 == 0) {
            return;
        }
        ZyLabelContent zyLabelContent = new ZyLabelContent(null);
        zyLabelContent.addLineContent(new ZyLineContent(String.valueOf(n2), new Font("New Courier", 0, 12), null));
        ZyProximityNodeRealizer zyProximityNodeRealizer = new ZyProximityNodeRealizer(zyLabelContent);
        p p2 = u2.k(zyProximityNodeRealizer);
        ZyProximityNode<SingleViewNode> zyProximityNode = new ZyProximityNode<SingleViewNode>(p2, zyProximityNodeRealizer, singleDiffNode, bl2);
        ZyNodeData<ZyProximityNode<SingleViewNode>> zyNodeData = new ZyNodeData<ZyProximityNode<SingleViewNode>>(zyProximityNode);
        zyProximityNodeRealizer.setUserData(zyNodeData);
        ZyEdgeRealizer<ZyInfoEdge> zyEdgeRealizer = new ZyEdgeRealizer<ZyInfoEdge>(new ZyLabelContent(null), null);
        zyEdgeRealizer.setLineType(ba.aLi);
        d d2 = u2.a(bl2 ? singleDiffNode.getNode() : zyProximityNode.getNode(), bl2 ? zyProximityNode.getNode() : singleDiffNode.getNode(), zyEdgeRealizer);
        ZyInfoEdge zyInfoEdge = new ZyInfoEdge(bl2 ? singleDiffNode : zyProximityNode, bl2 ? zyProximityNode : singleDiffNode, d2, zyEdgeRealizer);
        ZyEdgeData<ZyInfoEdge> zyEdgeData = new ZyEdgeData<ZyInfoEdge>(zyInfoEdge);
        zyEdgeRealizer.setUserData(zyEdgeData);
    }

    private static void unhideAllNodes(BinDiffGraph<? extends ZyGraphNode<?>, ?> binDiffGraph) {
        for (ZyGraphNode<?> zyGraphNode : binDiffGraph.getNodes()) {
            if (zyGraphNode.isVisible()) continue;
            zyGraphNode.getRawNode().setVisible(true);
        }
    }

    private static <NodeType extends ZyGraphNode<?>> void updateGraphVisibility(BinDiffGraph<NodeType, ?> binDiffGraph) {
        HashSet<NodeType> hashSet = new HashSet<NodeType>(binDiffGraph.getSelectedNodes());
        HashSet<NodeType> hashSet2 = new HashSet<NodeType>(binDiffGraph.getNodes());
        hashSet2.removeAll(hashSet);
        binDiffGraph.showNodes(hashSet, hashSet2);
    }

    private static void updateProximityBrowserInAsyncMode(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        if (binDiffGraph instanceof CombinedGraph) {
            ProximityBrowserUpdater.updateGraphVisibility(binDiffGraph);
            ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph);
            ProximityBrowserUpdater.createProximityNodesAndEdges((CombinedGraph)binDiffGraph);
        } else if (binDiffGraph instanceof SingleGraph) {
            ProximityBrowserUpdater.updateGraphVisibility(binDiffGraph);
            ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph);
            ProximityBrowserUpdater.createProximityNodesAndEdges((SingleGraph)binDiffGraph);
        }
    }

    static void adoptSuperGraphVisibility(SuperGraph superGraph) {
        Object object;
        Object object2;
        for (Object object3 : superGraph.getNodes()) {
            object2 = ((SuperDiffNode)object3).getPrimaryDiffNode();
            if (object2 != null) {
                ((SingleDiffNode)object2).getRawNode().setVisible(((ZyGraphNode)object3).isVisible());
            }
            if ((object = ((SuperDiffNode)object3).getSecondaryDiffNode()) == null) continue;
            ((SingleDiffNode)object).getRawNode().setVisible(((ZyGraphNode)object3).isVisible());
        }
        for (Object object3 : superGraph.getEdges()) {
            object2 = ((SuperDiffEdge)object3).getPrimaryDiffEdge();
            object = ((SuperDiffEdge)object3).getSecondaryDiffEdge();
            if (object2 != null) {
                ((SingleViewEdge)((SuperDiffEdge)object3).getPrimaryDiffEdge().getRawEdge()).setVisible(((ZyGraphEdge)object3).isVisible());
            }
            if (object == null) continue;
            ((SingleViewEdge)((SuperDiffEdge)object3).getSecondaryDiffEdge().getRawEdge()).setVisible(((ZyGraphEdge)object3).isVisible());
        }
    }

    static void createProximityNodesAndEdges(CombinedGraph combinedGraph) {
        U u2 = combinedGraph.getGraph();
        for (CombinedDiffNode combinedDiffNode : combinedGraph.getNodes()) {
            if (!combinedDiffNode.isVisible()) continue;
            HashSet<CombinedDiffNode> hashSet = new HashSet<CombinedDiffNode>();
            for (CombinedDiffNode combinedDiffNode2 : combinedDiffNode.getParents()) {
                if (combinedDiffNode2.isVisible()) continue;
                hashSet.add(combinedDiffNode2);
            }
            ProximityBrowserUpdater.createNewProximityNodeAndEdge(u2, combinedDiffNode, hashSet.size(), false);
            HashSet hashSet2 = new HashSet();
            for (CombinedDiffNode combinedDiffNode3 : combinedDiffNode.getChildren()) {
                if (combinedDiffNode3.isVisible()) continue;
                hashSet2.add(combinedDiffNode3);
            }
            ProximityBrowserUpdater.createNewProximityNodeAndEdge(u2, combinedDiffNode, hashSet2.size(), true);
        }
    }

    static void createProximityNodesAndEdges(SingleGraph singleGraph) {
        U u2 = singleGraph.getGraph();
        for (SingleDiffNode singleDiffNode : singleGraph.getNodes()) {
            if (!singleDiffNode.isVisible()) continue;
            HashSet<SingleDiffNode> hashSet = new HashSet<SingleDiffNode>();
            for (SingleDiffNode singleDiffNode2 : singleDiffNode.getParents()) {
                if (singleDiffNode2.isVisible()) continue;
                hashSet.add(singleDiffNode2);
            }
            ProximityBrowserUpdater.createNewProximityNodeAndEdge(u2, singleDiffNode, hashSet.size(), false);
            HashSet hashSet2 = new HashSet();
            for (SingleDiffNode singleDiffNode3 : singleDiffNode.getChildren()) {
                if (singleDiffNode3.isVisible()) continue;
                hashSet2.add(singleDiffNode3);
            }
            ProximityBrowserUpdater.createNewProximityNodeAndEdge(u2, singleDiffNode, hashSet2.size(), true);
        }
    }

    static void createProximityNodesAndEdges(SuperGraph superGraph) {
        U u2 = superGraph.getPrimaryGraph().getGraph();
        U u3 = superGraph.getSecondaryGraph().getGraph();
        if (superGraph.getSettings().getProximitySettings().getProximityBrowsing()) {
            for (p p2 : superGraph.getGraph().ar()) {
                SingleDiffNode singleDiffNode;
                int n2;
                SingleDiffNode singleDiffNode2;
                int n3;
                SuperDiffNode superDiffNode;
                p p3;
                d d2;
                bQ bQ2 = superGraph.getGraph().dN(p2);
                if (!(bQ2 instanceof ZyProximityNodeRealizer)) continue;
                if (p2.aJ() == 0 && p2.aK() == 1) {
                    d2 = p2.aL();
                    p3 = d2.V();
                    superDiffNode = (SuperDiffNode)superGraph.getNode(p3);
                    n3 = 0;
                    singleDiffNode2 = superDiffNode.getPrimaryDiffNode();
                    if (singleDiffNode2 != null) {
                        n3 = NodeHelpers.countInvisibleIndegreeNeighbours(singleDiffNode2.getRawNode());
                        ProximityBrowserUpdater.createNewProximityNodeAndEdge(u2, singleDiffNode2, n3, false);
                    }
                    n2 = 0;
                    singleDiffNode = superDiffNode.getSecondaryDiffNode();
                    if (singleDiffNode == null) continue;
                    n2 = NodeHelpers.countInvisibleIndegreeNeighbours(singleDiffNode.getRawNode());
                    ProximityBrowserUpdater.createNewProximityNodeAndEdge(u3, singleDiffNode, n2, false);
                    continue;
                }
                if (p2.aJ() == 1 && p2.aK() == 0) {
                    d2 = p2.aM();
                    p3 = d2.U();
                    superDiffNode = (SuperDiffNode)superGraph.getNode(p3);
                    n3 = 0;
                    singleDiffNode2 = superDiffNode.getPrimaryDiffNode();
                    if (singleDiffNode2 != null) {
                        n3 = NodeHelpers.countInvisibleOutdegreeNeighbours(singleDiffNode2.getRawNode());
                        ProximityBrowserUpdater.createNewProximityNodeAndEdge(u2, singleDiffNode2, n3, true);
                    }
                    n2 = 0;
                    singleDiffNode = superDiffNode.getSecondaryDiffNode();
                    if (singleDiffNode == null) continue;
                    n2 = NodeHelpers.countInvisibleOutdegreeNeighbours(singleDiffNode.getRawNode());
                    ProximityBrowserUpdater.createNewProximityNodeAndEdge(u3, singleDiffNode, n2, true);
                    continue;
                }
                logger.at(Level.SEVERE).log("Malformed graph. Super proximity node without incoming or outgoing edge.");
            }
        }
    }

    static void deleteAllProximityNodes(BinDiffGraph<?, ?> binDiffGraph) {
        U u2 = binDiffGraph.getGraph();
        try {
            u2.av();
            ((ProximityBrowser)binDiffGraph.getProximityBrowser()).deleteProximityBrowsingNodes();
            q q2 = u2.at();
            while (q2.J()) {
                if (u2.dN(q2.aU()) instanceof ZyProximityNodeRealizer) {
                    if (q2.aU().T() == u2) {
                        u2.h(q2.aU());
                    } else {
                        throw new GraphLayoutException("Delete proximity node failed. Couldn't update proximity browsing.");
                    }
                }
                q2.next();
            }
        }
        finally {
            u2.aw();
        }
    }

    public static void executeStatic(BinDiffGraph<? extends ZyGraphNode<?>, ? extends ZyGraphEdge<?, ?, ?>> binDiffGraph) {
        block8: {
            try {
                GraphProximityBrowsingSettings graphProximityBrowsingSettings = binDiffGraph.getSettings().getProximitySettings();
                if (graphProximityBrowsingSettings.getProximityBrowsing() && !graphProximityBrowsingSettings.getProximityBrowsingFrozen()) {
                    boolean bl2 = binDiffGraph.getSettings().getLayoutSettings().getAutomaticLayouting();
                    binDiffGraph.getSettings().getLayoutSettings().setAutomaticLayouting(false);
                    if (binDiffGraph.getSettings().isSync()) {
                        ProximityBrowserUpdater.updateGraphVisibility(binDiffGraph.getCombinedGraph());
                        ProximityBrowserUpdater.updateGraphVisibility(binDiffGraph.getSuperGraph());
                        ProximityBrowserUpdater.adoptSuperGraphVisibility(binDiffGraph.getSuperGraph());
                        ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getPrimaryGraph());
                        ProximityBrowserUpdater.deleteAllProximityNodes(binDiffGraph.getSecondaryGraph());
                        ProximityBrowserUpdater.createProximityNodesAndEdges(binDiffGraph.getSuperGraph());
                    } else {
                        ProximityBrowserUpdater.updateProximityBrowserInAsyncMode(binDiffGraph);
                    }
                    GraphsIntermediateListeners.notifyIntermediateVisibilityListeners(binDiffGraph);
                    binDiffGraph.getSettings().getLayoutSettings().setAutomaticLayouting(bl2);
                    break block8;
                }
                if (graphProximityBrowsingSettings.getProximityBrowsing()) break block8;
                try {
                    ProximityBrowserUpdater.unhideAllNodes(binDiffGraph.getSuperGraph());
                    ProximityBrowserUpdater.unhideAllNodes(binDiffGraph.getPrimaryGraph());
                    ProximityBrowserUpdater.unhideAllNodes(binDiffGraph.getSecondaryGraph());
                    ProximityBrowserUpdater.unhideAllNodes(binDiffGraph.getCombinedGraph());
                }
                catch (Exception exception) {
                    throw new GraphLayoutException(exception, "Failed to unhide node. Couldn't update proximity browser.");
                }
            }
            catch (GraphLayoutException graphLayoutException) {
                throw graphLayoutException;
            }
            catch (Exception exception) {
                throw new GraphLayoutException(exception, "Failed to update proximity browser.");
            }
        }
    }

    @Override
    public void execute() {
        ProximityBrowserUpdater.executeStatic(this.referenceGraph);
    }
}

